# Example 1 (p. 2)
library(tidyverse)
library(anomalyDetection)

security_logs

# Example 2 (p. 3)
tabulate_state_vector(security_logs, 10)

# Example 3 (p. 3)
(state_vec <- security_logs %>%
    tabulate_state_vector(10) %>%
    mc_adjust())

# Example 4 (p. 4)
state_vec %>%
  mahalanobis_distance("both", normalize = TRUE) %>%
  as_tibble

# Example 5 (p. 4)
state_vec %>%
  mahalanobis_distance("both", normalize = TRUE) %>%
  as_tibble %>%
  dplyr::mutate(Block = 1:n()) %>%
  gather(Variable, BD, -c(MD, Block)) %>%
  ggplot(aes(factor(Block), Variable, color = MD, size = BD)) +
  geom_point()

# Example 6 (p. 5)
state_vec %>%
  mahalanobis_distance("bd", normalize = TRUE) %>%
  bd_row(17, 10)

# Example 7 (p. 6)
horns_curve(state_vec)

# Example 8 (p. 6)
state_vec %>%
  horns_curve() %>%
  factor_analysis(state_vec, hc_points = .) %>%
  names()

# Example 9 (p. 6)
state_vec %>%
  horns_curve() %>%
  factor_analysis(state_vec, hc_points = .) %>%
  factor_analysis_results(4) %>%
  as_tibble

# Example 10 (p. 7)
state_vec %>%
  horns_curve() %>%
  factor_analysis(data = state_vec, hc_points = .) %>%
  factor_analysis_results(fa_loadings_rotated) %>%
  kaisers_index()

# Example 11 (p. 7)
fa_loadings <- state_vec %>%
  horns_curve() %>%
  factor_analysis(state_vec, hc_points = .) %>%
  factor_analysis_results(fa_loadings_rotated)

row.names(fa_loadings) <- colnames(state_vec)

gplots::heatmap.2(fa_loadings, dendrogram = 'both', trace = 'none',
                  density.info = 'none', breaks = seq(-1, 1, by = .25),
                  col = RColorBrewer::brewer.pal(8, 'RdBu'))

# Example 12 (p. 8)
state_vec %>%
  horns_curve() %>%
  factor_analysis(state_vec, hc_points = .) %>%
  factor_analysis_results(fa_scores_rotated) %>%
  as_tibble() %>%
  dplyr::mutate(Block = 1:n()) %>%
  gather(Factor, Score, -Block) %>%
  dplyr::mutate(Absolute_Score = abs(Score)) %>%
  ggplot(aes(Factor, Absolute_Score, label = Block)) +
  geom_text(size = 2) +
  geom_boxplot(outlier.shape = NA)

# Example 13 (p. 9)
principal_components(state_vec) %>% names

# Example 14 (p. 10)
state_vec %>%
  principal_components() %>%
  principal_components_result(pca_rotated) %>%
  as_tibble

