####################################################
####################################################
# R code extracted from siberchicot et al
####################################################
####################################################

####################################################
####################################################
# Introduction

set.seed(70)
library(ade4)
library(adegraphics)



####################################################
####################################################
# A simple example

data("mafragh")
names(mafragh)



####################################################
####################################################
# Basic elements and simple graphs


####################################################
# Classes, objects and calling functions

pca1 <- dudi.pca(mafragh$env, scale = TRUE, center = TRUE, scannf = FALSE,
                 nf = 4)

g_sl1 <- s.label(pca1$li, plot = FALSE)
class(g_sl1)

g_sc1 <- s.corcircle(pca1$co)
class(g_sc1)

slotNames(g_sc1)
g_sc1@Call


####################################################
# Graphical parameters

g_sc2 <- s.corcircle(pca1$co, plabels.boxes.draw = FALSE, 
                     psub.text = "Correlations of the environmental variables", 
                     plot = FALSE)
g_sc2@adeg.par$pbackground$col


####################################################
# Manipulating a simple graph

update(g_sc2, pgrid.col = "white", pbackground.col = "grey90")
g_sc2@adeg.par$pbackground$col


####################################################
# Representation of spatial information

class(mafragh$Spatial.contour)

library(RColorBrewer)
valuecolors <- rev(brewer.pal(6, "RdBu"))

g_sv1 <- s.value(mafragh$xy, z = pca1$li[, 1], Sp = mafragh$Spatial.contour, 
                 method = "color", symbol = "circle", col = valuecolors, 
                 pgrid.draw = FALSE, ppoints.cex = 0.4)

library(sp)
spobj <- SpatialPolygonsDataFrame(Sr = mafragh$Spatial, 
                                  data = pca1$li[, 1, drop = FALSE], 
                                  match.ID = FALSE)
class(spobj)

g_sp1 <- s.Spatial(spobj, col = valuecolors)



####################################################
####################################################
# Dealing with multiple graphs


####################################################
# Automatic collections

g_sv2 <- s.value(mafragh$xy, z = pca1$li[, 1], facets = mafragh$partition, 
                 Sp = mafragh$Spatial.contour, method = "color", 
                 symbol = "circle", col = valuecolors, pgrid.draw = FALSE, 
                 ppoints.cex = 0.4)

class(g_sv2)
names(g_sv2)
class(g_sv2$C1)

selectedspecies <- c(9, 12, 31, 34)
floselectedspecies <- mafragh$flo[, selectedspecies]
colnames(floselectedspecies) <- mafragh$spenames$code[selectedspecies]
colnames(floselectedspecies)

g_sv3 <- s.value(mafragh$xy, z = floselectedspecies, symbol = "circle", 
                 centerpar = list(cex = 0.1), ppoints.cex = 0.7, 
                 pgrid.draw = FALSE, psub.cex = 2, porigin.draw = FALSE, 
                 plegend.drawK = FALSE, Sp = mafragh$Spatial.contour)


####################################################
# Step-by-step creation

coa1 <- dudi.coa(mafragh$flo, scannf = FALSE, nf = 2)
g_sl2 <- s.label(coa1$co, labels = mafragh$spenames$code, plabel.optim = TRUE, 
                 plot = FALSE)

g_in1 <- insert(g_sv3[[1]], g_sl2, posi = c(0.06, 0.16), plot = FALSE)
g_in1 <- insert(g_sv3[[2]], g_in1, posi = c(0.15, 0.75), plot = FALSE)
g_in1 <- insert(g_sv3[[3]], g_in1, posi = c(0.57, 0.77))

class(g_in1)

names(g_in1)
names(g_in1) <- c("CA", "Juma", "Scli", "Boof")
names(g_in1)

g_in1@positions
g_in2 <- ADEgS(list(CA = g_sl2, Juma = g_sv3[[1]], Scli = g_sv3[[2]], 
                    Boof = g_sv3[[3]]), 
               positions = rbind(c(0, 0, 1, 1), c(0.06, 0.16, 0.26, 0.36), 
                                 c(0.15, 0.75, 0.35, 0.95), 
                                 c(0.57, 0.77, 0.77, 0.97)), plot = FALSE)


####################################################
# Customizing an ADEgS

# update(g_in1, pbackground.col = "grey90")
# update(g_in1, CA.pbackground.col = "grey90")

oldadegpar <- adegpar()

adegpar(p1d = list(horizontal = FALSE, rug.tck = 1, margin = 0.07))
g_gau1d <- s1d.gauss(pca1$li[, 1], fac = mafragh$partition, col = c(1:6, 8), 
                     p1d.reverse = TRUE, p1d.rug.margin = 0.1, plabels.cex = 2, plot = FALSE)
g_lab1d <- s1d.label(pca1$co[, 1], labels = rownames(pca1$co), plabels.cex = 2, 
                     plot = FALSE)


g_eig <- plotEig(pca1$eig, xax = 1, yax = 1, nf = 1, pbackground.box = TRUE, plot = FALSE)
g_adegs1 <- ADEgS(list(g_gau1d, g_lab1d, g_sv1, g_eig),
                  layout = matrix(c(1, 2, 3, 1, 2, 4), nrow = 2, byrow = TRUE), plot = FALSE)

names(g_adegs1)

update(g_adegs1, pgrid.draw = FALSE, psub.cex = 1.6, 
       g3.psub = list(text = "Map of scores of the first PCA axis"), 
       g4.psub = list(text = "PCA eigenvalues"))
adegpar(oldadegpar)


####################################################
# Multivariate analysis outputs

pca2 <- dudi.pca(mafragh$env, row.w = coa1$lw, scannf = FALSE, nf = 2)
coi1 <- coinertia(coa1, pca2, scannf = FALSE, nf = 3)
g_coi1 <- plot(coi1)

length(g_coi1)
names(g_coi1)
g_coi1$XYmatch      # the same as g_coi1[[4]]
g_coi1@Call

g_coi1$XYmatch@Call

g_scl1 <- s.class(coi1$mX, fac = mafragh$partition, ellipseSize = 0, 
                  chullSize = 0, starSize = 0.5, ppoints.cex = 0, 
                  col = c(1:6, 8), plot = FALSE)
g_scl2 <- s.class(coi1$mY, fac = mafragh$partition, ellipseSize = 0, 
                  chullSize = 0, starSize = 0.5, ppoints.cex = 0, 
                  col = c(1:6, 8), plot = FALSE)
g_scs1 <- superpose(g_scl1, g_scl2)
g_sm1 <- s.match(g_scl1@stats$means, g_scl2@stats$means, plabels.cex = 0, 
                 plines.lwd = 2, plot = FALSE)
g_scl <- superpose(g_scs1, g_sm1)

g_scl <- insert(g_coi1$eig, g_scl, posi = "topleft", ratio = 0.3, plot = FALSE)

g_yload <- g_coi1$Yloadings
update(g_yload, plabels.box.draw = FALSE, pgrid.draw = FALSE, psub.cex = 1.2, 
       plot = FALSE)

g_sl3 <- s.label(dfxy = coi1$c1, psub = list(text = "X loadings"), 
                 labels = mafragh$spenames$code, plabels.optim = TRUE,
                 plabels.cex = 1.2, psub.cex = 1.2, ppoints.cex = 0, 
                 pgrid.draw = FALSE, plot = FALSE)

g_adegs2 <- ADEgS(list(g_scl, g_yload, g_sl3), 
                  layout = list(mat = matrix(c(1, 1, 2, 1, 1, 3), 
                                             nrow = 2, byrow = TRUE)))
