# package installation & loading
install.packages("LeArEst")
library(LeArEst)

# Length estimation - a numerical data set
set.seed(12)
sample_1 <- runif(1000, -1, 1)
sample_2 <- rnorm(1000, 0, 0.1)
sample <- sample_1 + sample_2
lengthest(x = sample, error = "gauss", var.est = "MM", conf.level = 0.90)

# Testing hypothesis - a numerical data set
set.seed(12)
sample_1 <- runif(1000, -1, 1)
sample_2 <- rnorm(1000, 0, 0.1)
sample <- sample_1 + sample_2
lengthtest(x = sample, error = "gauss", alternative = "less", var.est = "MM", null.a = 1, conf.level = 0.95)

# Area estimation - a numerical data set
inputfile <- system.file("extdata", "ellipse_3_4_0.1_laplace.txt", package = "LeArEst")
inputdata <- read.table(inputfile)
areaest(inputdata, error = "laplace", var.est = "ML", nrSlices = 5, plot = TRUE)

# Length estimation and testing for an object shown in a picture
startweb.esttest()

# Area estimation of an object shown in a picture
startweb.area()