

## Section: The afmToolkit package

# If you install from CRAN
install.packages("afmToolkit")

# Uncomment these lines if you install from github
# install.packages("devtools")
# library("devtools")
# install_github("rbensua/afmToolkit")


library(afmToolkit)


## Importing data
## Importing data from JPK^TM ASCII files:

data <- afmReadJPK("force-save-JPK-2h.txt.gz", path = path.package("afmToolkit"))

str(data)
plot(data)


## Importing data from Veeco^TM ASCII files:

dataVeeco <- afmReadVeeco("veeco_file.txt.gz",
                          path = path.package("afmToolkit"))

## Contact point and detach point determination
## Contact point:

width <- 20
mul1 <- 1
mul2 <- 10
data <- afmContactPoint(data, width, mul1, mul2)
plot(data, segment = "approach") +
  geom_vline(xintercept = data$CP$CP, lty = 2)

## Detach point:

data <- afmDetachPoint(data, width = 20, mul1 = 1, mul2 = 10)
plot(data, segment = "retract") +
  geom_vline(xintercept = data$DP$DP, lty = 2)



## Baselinecorrection

data <- afmBaselineCorrection(data)
plot(data)


## Zero force point

data <- afmZeroPointSlope(data, segment = "approach")
plot(data, segment = "approach") +
  geom_vline(xintercept = data$CP$CP, col = "red", lty = 2) +
  geom_vline(xintercept = data$Slope$Z0Point, col = "blue", lty = 3)

## Young's modulus estimation

data <- afmIndentation(data) # First compute the indentation
data <- afmYoungModulus(data, thickness = , 5e-9,
                          params = list(alpha = 22))
data$YoungModulus$YoungModulus

## Exponential decay fit


data <- afmReadJPK("force-save-JPK-3h.txt.gz",
                   path = path.package("afmToolkit"))

data <- afmContactPoint(data, width, mul1, mul2)
data <- afmDetachPoint(data, width , mul1, mul2)
data <- afmBaselineCorrection(data)
data <- afmZeroPointSlope(data, segment = "approach")
plot(data, segment = "pause" , vs = "Time")
data1 <- afmExpDecay(data, nexp = 1, tmax = 7.5,type = "CH",
                     start = c(a0 = 8.2e-7, a1 = 3.35e-7, tau1 = 5))
data <- afmExpDecay(data, nexp = 2, tmax = 7.5,type = "CH",
                    start = c(a0 = 8.2e-7, a1 = 1.675e-7,
                              a2 = 1.675e-7, tau1 = 5, tau2 = 0.1))

summary(data1$ExpFit$expdecayModel)
summary(data$ExpFit$expdecayModel)

## Adhesion energy

data <- afmAdhesionEnergy(data, width = 10, mul = 15)
data$AdhEner$Points
data$AdhEner$Energies


## Summarizing an "afmdata" class

data <- afmIndentation(data)
data <- afmYoungModulus(data, thickness = 5e-8,
                          params = list(alpha = 22))
summary(data)

## A sample R afmToolkit session for batch processing


dataFolder <- paste(path.package("afmToolkit"),"afmexperiment",sep = "/")
data <- afmReadJPKFolder(dataFolder)
class(data)


data(batchExperiment)
str(batchExperiment[[1]]$params)

# Preprocessing the curves
width <- 50
mul1 <- 1
mul2 <- 10
batchExperiment <- afmContactPoint(batchExperiment, width=width,
                                     mul1 = mul1, mul2 = mul2)
batchExperiment <- afmDetachPoint(batchExperiment, width=width,
                                    mul1 = mul1, mul2 = mul2)
batchExperiment <- afmBaselineCorrection(batchExperiment)
batchExperiment <- afmZeroPointSlope(batchExperiment,
                                       segment = "approach")
batchExperiment <- afmIndentation(batchExperiment)

# Curve analysis
batchExperiment <- afmYoungModulus(batchExperiment,
                                   thickness = 2.5e-7,
                                   geometry = "paraboloid",
                                   params = list(R = 1e-8))
batchExperiment <- afmExpDecay(batchExperiment, nexp = 2,
                                 type = "CH", plt = FALSE, tmax = 5)
batchExperiment <- afmAdhesionEnergy(batchExperiment,
                                       width = 5, mul = 15)


head(summary(batchExperiment))

# Extracting the results

parameters <- afmExtract(batchExperiment,
                         params = list("YM", "AE", "ED"),
                         opt.param = "type")

library(dplyr)
parameters[[1]] %>% ggplot(aes(x = type, y = YM)) +
  geom_boxplot() + ylab("Young's Modulus (Pa)")
parameters[[1]] %>% ggplot(aes(x = type, y = Etotal)) +
  geom_boxplot() + ylab("Total Adhesion Energy (J)")
parameters[[2]] %>% ggplot(aes(x = type, y = Estimate)) +
  geom_boxplot() + facet_wrap(~parameter, scales = "free")
