library(liureg)

mod <- liu(y ~ X1 + X2 + X3 + X4, data = as.data.frame(Hald),
           scaling = "centered", d = seq(-2, 2, 0.2) )

mod$coef #scaled coefficients
summary(mod) #testing of Liu coefficients
dest(mod) # Computation of biasing parameters
lstats(mod) # Computation of Liu related statistics
vcov(liu(y ~ ., as.data.frame(Hald), d = -1.47218)) # var-cov matrix for d=-1.47218

hatl(mod)  # Liu hat matrix
halt(mod)[[1]] # Liu hat matrix for first biasing parameter
diag(hatl(mod)[[1]])  # diagonal elements of Liu hat matrix
vcov(mod) # Var-Cov matrix for all input ds
residual(mod) # Liu residuals
fitted(mod)  # Liu fiffted values
predict(mod) # Liu predicted values
lstats(mod)$lEDF # Liu EDF
lstats(mod)$var  # Liu Variance

# Predicted values of Liu
predict(mod, newdata = as.data.frame(Hald[1 : 5, -1]))
infoliu(liu(y ~ ., as.data.frame(Hald), d = c(-1.47218, -0.06, 0.5, 1)))

# ==== Liu related plots ====
mod1 <- liu(y ~ X1 + X2 + X3 + X4, data = as.data.frame(Hald),
           scaling = "centered", d = seq(-5, 5, 0.01) )

plot(mod1) # Liu trace
plot.biasliu(mod1) # Liu bias, variance and mse plot
plot.infoliu(mod1) # liu AIC and BIC plot
