## Load the package
library(queueing)

## First and basic Model

# Basic M/M/1 model
i_mm1 <- NewInput.MM1(lambda=2, mu=3)
CheckInput(i_mm1)
o_mm1 <- QueueingModel(i_mm1)
print(summary(o_mm1), digits=2)

# Distribution function of w and wq
gTitle <- "Distribution function of w and wq"
fw     <- o_mm1$FW
fwq    <- o_mm1$FWq
n      <- 10
ty     <- "l"
ylab   <- "FW(t), FWq(t)"
xlab   <- "t"
cols   <- c("black", "red")
leg    <- c("FW(t)", "FWq(t)")

curve(fw, from=0, to=n, type=ty, ylab=ylab, xlab=xlab, col=cols[1], main=gTitle)
curve(fwq, from=0, to=n, type=ty, col=cols[2], add=T)
legend("bottomright", leg, lty=c(1, 1), col=cols)


## Performance metrics comparision

# Change the input parameter lambda in the model M/M/1:
L_f_aux   <- function(x){L  (QueueingModel(NewInput.MM1(lambda=x, mu=1, n=-1)))}
Lq_f_aux  <- function(x){Lq (QueueingModel(NewInput.MM1(lambda=x, mu=1, n=-1)))}
Lqq_f_aux <- function(x){Lqq(QueueingModel(NewInput.MM1(lambda=x, mu=1, n=-1)))}

L_f   <- function(v){sapply(v, L_f_aux)}
Lq_f  <- function(v){sapply(v, Lq_f_aux)}
Lqq_f <- function(v){sapply(v, Lqq_f_aux)}

gt     <- "L, Lq and Lqq"
ylab   <- "L, Lq, Lqq"
xlab   <- "rho"
n      <- 100
to     <- 0.99
ty     <- "l"
lty    <- c(1, 1, 1)
cols   <- c("blue", "red", "green")
leg    <- c("L", "Lq", "Lqq")

curve(L_f,   from=0, to=to, n=n, ylab=ylab, xlab=xlab, col=cols[1], type=ty, main=gt)
curve(Lq_f,  from=0, to=to, n=n, col=cols[2], add=T, type=ty)
curve(Lqq_f, from=0, to=to, n=n, col=cols[3], add=T, type=ty)
legend("topleft", leg, lty=c(1, 1, 1), col=cols)

# Showing insight L_qq > L always in 1
x <- seq(from=0, to=0.99, by=0.01)
Lqq_f(x) - L_f(x)

# Change the input parameter c in the model M/M/c:
W_f_aux   <- function(x){W  (QueueingModel(NewInput.MMC(lambda=x, mu=1.01, c=x)))}
Wq_f_aux  <- function(x){Wq (QueueingModel(NewInput.MMC(lambda=x, mu=1.01, c=x)))}
W_f       <- function(v){sapply(v, W_f_aux)}
Wq_f      <- function(v){sapply(v, Wq_f_aux)}
gt        <- "W and Wq"
ylab      <- "W, Wq"
xlab      <- "lambda, c"
n         <- 14
ty        <- "l"
leg       <- c("W", "Wq")
lty       <- c(1, 1, 1)
cols      <- c("blue", "red")

curve(W_f, from=1, to=n, n=n, ylab=ylab, xlab=xlab , col=cols[1], type=ty, main=gt)
curve(Wq_f,  from=1, to=n, n=n, col=cols[2], add=T, type=ty)
legend("topright", leg, lty=lty, col=cols)


# Comparing different models
o_mm2  <- QueueingModel(NewInput.MMC(lambda=2, mu=3, c=2))
o_mm2k <- QueueingModel(NewInput.MM1K(lambda=2, mu=3, k=5))
CompareQueueingModels(o_mm1, o_mm2, o_mm2k)


## Queueing Network Models
# Hospital Model
data     <- c(0, 0.3, 0.2, 0, 0, 0, 0, 0, 0.7, 0.1, 0, 0, 0, 0.8, 0.15, 0, 0.4, 0.3, 0, 0.3)
prob     <- matrix(data=data, byrow = TRUE, nrow = 5, ncol=5)
gd       <- NewInput.MM1(lambda=10, mu=25, n=0)
ort      <- NewInput.MM1(lambda=0, mu=18, n=0)
car      <- NewInput.MM1(lambda=0, mu=20, n=0)
tb       <- NewInput.MMC(lambda=0, mu=12, c=15, n=0)
hos      <- NewInput.MMInf(lambda=0, mu=0.012, n=0)
hospital <- NewInput.OJN(prob=prob, gd, ort, car, tb, hos)
CheckInput(hospital)
m_hospital <- QueueingModel(hospital)
print(summary(m_hospital), digits = 2)


# Priority Hospital Model
classes   <- 2
vLambda   <- c(2, 10)
nodes     <- 5
vType	    <- c("Q", "Q", "Q", "Q", "D")
vHigh     <- c(2, 4, 2, 6, 2)
vNorm     <- c(1, 2, 1, 3, 0.5)
vVisit	  <- matrix(data=c(vHigh, vNorm), nrow=2, ncol=5, byrow = TRUE)
sHigh     <- c(1/100, 1/250, 1/300, 1/600, 1/5)
sNorm     <- c(1/90, 1/150, 1/200, 1/300, 1/3)
vService  <-matrix(data=c(sHigh, sNorm), nrow=2, ncol=5, byrow = TRUE)
cl_hosp   <- NewInput.MCON(classes, vLambda, nodes, vType, vVisit, vService)
CheckInput(cl_hosp)
m_cl_hosp <- QueueingModel(cl_hosp)
print(summary(m_cl_hosp), digits = 2)

## Queueing Calculators

# B-Erlang
servers    <- 1:50
numServers <- length(servers)
rho        <- c(1, 5, 10, 15, 20, 24, 30, 40, 50)
rho_size   <- length(rho)
pRes       <- array(data=0, dim=c(numServers, rho_size))

for (i in 1:numServers)
  for (j in 1:rho_size)
    pRes[i, j] <- B_erlang(i, rho[j])

colrs <- rainbow(n=rho_size)
xlim  <- c(1, numServers)
ylim  <- c(0, 1)
xlab  <- "Number of servers"
ylab  <- "Probability"
gt    <- "B-Erlang prob. for different loads"
y     <- pRes[, 1]
x     <- servers
col   <- colrs[1]

plot(x=x, y=y, xlim=xlim, ylim=ylim, type="l", col=col, xlab=xlab, ylab=ylab, main=gt)

for (j in 2:rho_size)
  lines(x=1:numServers, y=pRes[, j], col=colrs[j])

leg <- as.character(rho)
tr  <- "topright"
lty <- rep(1, rho_size)
lwd <- rep(0.01, rho_size)
legend(x=tr, legend=leg, lty=lty, lwd=lwd, col=colrs)