# One-Parameter Lindley Distribution --------------------------------------
lindley.bc <- function(n, mle)
{
  theta <- mle
  c(theta = (theta^3+6.*theta^2+6.*theta+2.)*(theta+1.)*theta/n/(theta^2+4.*theta+2.)^2)
}

# One-Parameter Inverse Lindley Distribution ------------------------------
invlindley.bc <- function(n, mle)
{
  theta <- mle
  c(theta = 0.10e1 / n * (theta + 1) / (theta ^ 2 + 4 * theta + 2) ^ 2 * theta * (theta ^ 3 + 6 * theta ^ 2 + 6 * theta + 2))
}

# One-Parameter Inverse Exponential Distribution --------------------------
invexp.bc <- function(n, mle)
{
  theta <- mle
  c(theta = theta / n)
}

# One-Parameter Shanker Distribution --------------------------------------
shanker.bc <- function(n, mle)
{
  Ei <- function(a, x){expint::expint_En(x = x, order = a)}
  theta <- mle
  c(theta = -theta * (theta ^ 2 + 0.1000000000e1) * (Ei(0.1e1, theta ^ 2) * exp(theta ^ 2) * theta ^ 10 + 0.2e1 * theta ^ 8 * exp(theta ^ 2) * Ei(0.1e1, theta ^ 2) + 0.3e1 * theta ^ 6 * exp(theta ^ 2) * Ei(0.1e1, theta ^ 2) - 0.1e1 * theta ^ 8 + 0.2e1 * theta ^ 4 * exp(theta ^ 2) * Ei(0.1e1, theta ^ 2) - 0.2e1 * theta ^ 6 - 0.13e2 * theta ^ 4 - 0.6e1 * theta ^ 2 - 0.2e1) / n / (theta ^ 6 * exp(theta ^ 2) * Ei(0.1e1, theta ^ 2) + theta ^ 4 * exp(theta ^ 2) * Ei(0.1e1, theta ^ 2) + 0.6e1 * theta ^ 2 + 0.2e1) ^ 2)
}

# One-Parameter Inverse Shanker Distribution ------------------------------
invshanker.bc <- function(n, mle)
{
  theta <- mle
  c(theta = (theta ^ 3 + 0.2e1 * theta) / (n * theta ^ 2 + 0.1e1 * n))
}

# One-Parameter Topp-Leone Distribution -----------------------------------
toppleone.bc <- function(n, mle)
{
  nu <- mle
  c(nu = nu / n)
}

# One-Parameter Levy Distribution -----------------------------------------
levy.bc <- function(n, mle)
{
  sigma <- mle[1]
  c(sigma = 2 * sigma / n)
}

# One-parameter Rayleigh Distribution -------------------------------------
rayleigh.bc <- function(n , mle)
{
  sigma = mle[1]
  c(sigma = - sigma / (8*n))
}

# One-Parameter Inverse Rayleigh Distribution -----------------------------
invrayleigh.bc <- function(n , mle)
{
  sigma = mle[1]
  c(sigma = 3*sigma / (8*n))
}

# One-Parameter Half-Logistic Distribution --------------------------------
halflogistic.bc <- function(n, mle)
{
  sigma <- mle[1]
  c(sigma = -0.5256766607e-1 / n *  sigma)
}

# One-Parameter Half-Cauchy Distribution ----------------------------------
halfcauchy.bc <- function(n, mle)
{
  sigma <- mle[1]
  c(sigma = sigma / n)
}

# One-Parameter Half-Normal Distribution ----------------------------------
halfnormal.bc <- function(n, mle)
{
  sigma <- mle[1]
  c(sigma = -0.2500000000e0 / n * sigma)
}

# Two-Parameter Normal Distribution ---------------------------------------
normal.bc <- function(n, mle)
{
  sigma <- mle[2]
  c(mu = 0, sigma = -3*sigma/(4 * n))
}

# Two-Parameter Inverse Gaussian Distribution -----------------------------
invgaussian.bc <- function(n, mle)
{
  lambda <- mle[2]
  c(mu = 0, lambda = 3*lambda / n)
}

# Two-Parameter Log-Normal Distribution -----------------------------------
lognormal.bc <- function(n, mle)
{
  sigma <- mle[2]
  c(mu = 0, sigma = -3*sigma/(4*n))
}

# Two-Parameter Gamma Distribution ----------------------------------------
gamma.bc <- function(n, mle)
{
  alpha <- mle[1]; lambda <- mle[2]
  c(alpha  = (alpha * (trigamma(alpha) - alpha * psigamma(alpha, 2)) - 2) / (2 * n * (alpha * trigamma(alpha) - 1)^2),
    lambda = lambda * (2 * alpha * trigamma(alpha) ^ 2 - 3 * trigamma(alpha) - alpha * psigamma(alpha, 2)) / (2 * n * (alpha * trigamma(alpha) - 1) ^ 2) )
}

# Two-Parameter Inverse Gamma Distribution -----------------------------
invgamma.bc <- function(n, mle)
{
 beta <- mle[1]; alpha <- mle[2]
 c(beta = beta * (-0.5e0 * alpha * psigamma(alpha, 2) - 0.15e1 * trigamma(alpha) + trigamma(alpha) ^ 2 * alpha) / n / (trigamma(alpha) * alpha - 0.1e1) ^ 2,
   alpha = (-0.5e0 * alpha ^ 2 * psigamma(alpha, 2) + 0.5e0 * trigamma(alpha) * alpha - 0.1e1) / n / (trigamma(alpha) * alpha - 0.1e1) ^ 2)
}

# Two-Parameter Lomax Distribution ----------------------------------------
lomax.bc <- function(n, mle)
{
  alpha <- mle[1]; beta <- mle[2]
  c(alpha = alpha / n * (alpha ^ 3 + 0.8e1 * alpha ^ 2 + 0.11e2 * alpha + 0.4e1) / (alpha + 0.3e1),
    beta = -0.2e1 * beta * (alpha + 0.164853527218163731e1) * (alpha + 0.393400907536166411e0) * (alpha - 0.154193617971780395e1) / n / alpha / (alpha + 0.3e1))
}

# Two-Parameter Weighted Lindley Distribution -----------------------------
wlindley.bc <- function(n, mle)
{
  alpha <- mle[1]; theta <- mle[2]
  c(alpha = 0.10e1 * (theta ^ 2 + (2 * alpha + 1) * theta + alpha ^ 2) / n / (alpha * (theta ^ 2 + (2 * alpha + 2) * theta + alpha ^ 2 + alpha) * trigamma(alpha) - theta ^ 2 + (-2 * alpha - 2) * theta - alpha ^ 2 - alpha - 1) * (-1 + (theta + alpha) ^ 2 * trigamma(alpha)) / (alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) * trigamma(alpha) - alpha ^ 2 + (-2 * theta - 1) * alpha - (theta + 1) ^ 2) * (alpha ^ 3 + 3 * alpha ^ 2 * theta + 3 * alpha * theta ^ 2 + theta ^ 3 + alpha ^ 2 + 3 * theta * alpha + 3 * theta ^ 2) * alpha / (theta + alpha) ^ 3 - 0.10e1 * (theta ^ 2 + (2 * alpha + 1) * theta + alpha ^ 2) ^ 2 / n / (alpha * (theta ^ 2 + (2 * alpha + 2) * theta + alpha ^ 2 + alpha) * trigamma(alpha) - theta ^ 2 + (-2 * alpha - 2) * theta - alpha ^ 2 - alpha - 1) ^ 2 * (alpha ^ 3 + 3 * alpha ^ 2 * theta + 3 * alpha * theta ^ 2 + theta ^ 3 + 2 * theta ^ 2) / (theta + alpha) ^ 3 - 0.30e1 * theta * (theta ^ 2 + (2 * alpha + 1) * theta + alpha ^ 2) / n / (alpha * (theta ^ 2 + (2 * alpha + 2) * theta + alpha ^ 2 + alpha) * trigamma(alpha) - theta ^ 2 + (-2 * alpha - 2) * theta - alpha ^ 2 - alpha - 1) * alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) / (alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) * trigamma(alpha) - alpha ^ 2 + (-2 * theta - 1) * alpha - (theta + 1) ^ 2) / (theta + alpha) ^ 3 - 0.5e0 * alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) / n / (alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) * trigamma(alpha) - alpha ^ 2 + (-2 * theta - 1) * alpha - (theta + 1) ^ 2) ^ 2 * (-1 + (theta + alpha) ^ 2 * trigamma(alpha)) * (alpha ^ 3 + 3 * alpha ^ 2 * theta + 3 * alpha * theta ^ 2 + theta ^ 3 + 2 * theta ^ 2) / (theta + alpha) ^ 3 - 0.5e0 * alpha ^ 2 * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) ^ 2 / n / (alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) * trigamma(alpha) - alpha ^ 2 + (-2 * theta - 1) * alpha - (theta + 1) ^ 2) ^ 2 * (psigamma(alpha, 2) * alpha ^ 3 + 3 * psigamma(alpha, 2) * theta * alpha ^ 2 + 3 * psigamma(alpha, 2) * theta ^ 2 * alpha + psigamma(alpha, 2) * theta ^ 3 + 2) / (theta + alpha) ^ 3,
    theta = 0.10e1 * theta * (-1 + (theta + alpha) ^ 2 * trigamma(alpha)) ^ 2 / n / (alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) * trigamma(alpha) - alpha ^ 2 + (-2 * theta - 1) * alpha - (theta + 1) ^ 2) ^ 2 * (alpha ^ 3 + 3 * alpha ^ 2 * theta + 3 * alpha * theta ^ 2 + theta ^ 3 + alpha ^ 2 + 3 * theta * alpha + 3 * theta ^ 2) * alpha / (theta + alpha) ^ 3 - 0.15e1 * theta * (-1 + (theta + alpha) ^ 2 * trigamma(alpha)) / n / (alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) * trigamma(alpha) - alpha ^ 2 + (-2 * theta - 1) * alpha - (theta + 1) ^ 2) * (theta ^ 2 + (2 * alpha + 1) * theta + alpha ^ 2) / (alpha * (theta ^ 2 + (2 * alpha + 2) * theta + alpha ^ 2 + alpha) * trigamma(alpha) - theta ^ 2 + (-2 * alpha - 2) * theta - alpha ^ 2 - alpha - 1) * (alpha ^ 3 + 3 * alpha ^ 2 * theta + 3 * alpha * theta ^ 2 + theta ^ 3 + 2 * theta ^ 2) / (theta + alpha) ^ 3 - 0.10e1 * theta ^ 2 * (-1 + (theta + alpha) ^ 2 * trigamma(alpha)) / n / (alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) * trigamma(alpha) - alpha ^ 2 + (-2 * theta - 1) * alpha - (theta + 1) ^ 2) ^ 2 * alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) / (theta + alpha) ^ 3 - 0.20e1 * theta ^ 2 * (theta ^ 2 + (2 * alpha + 1) * theta + alpha ^ 2) ^ 2 / n / (alpha * (theta ^ 2 + (2 * alpha + 2) * theta + alpha ^ 2 + alpha) * trigamma(alpha) - theta ^ 2 + (-2 * alpha - 2) * theta - alpha ^ 2 - alpha - 1) ^ 2 / (theta + alpha) ^ 3 - 0.5e0 * theta * (theta ^ 2 + (2 * alpha + 1) * theta + alpha ^ 2) / n / (alpha * (theta ^ 2 + (2 * alpha + 2) * theta + alpha ^ 2 + alpha) * trigamma(alpha) - theta ^ 2 + (-2 * alpha - 2) * theta - alpha ^ 2 - alpha - 1) * alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) / (alpha * (alpha ^ 2 + (2 * theta + 1) * alpha + theta ^ 2 + 2 * theta) * trigamma(alpha) - alpha ^ 2 + (-2 * theta - 1) * alpha - (theta + 1) ^ 2) * (psigamma(alpha, 2) * alpha ^ 3 + 3 * psigamma(alpha, 2) * theta * alpha ^ 2 + 3 * psigamma(alpha, 2) * theta ^ 2 * alpha + psigamma(alpha, 2) * theta ^ 3 + 2) / (theta + alpha) ^ 3)
}

# Two-Parameter Generalized Rayleigh Distribution -------------------------
generalizedrayleigh.bc <- function(n, mle){
  alpha <- mle[1]; theta <- mle[2]
  bias.alpha <- (-alpha ^ 3 - 0.15e1 * alpha ^ 2 - 0.25e1 * alpha - 0.5e0 * alpha ^ 5 * psigamma(alpha, 2) - alpha ^ 4 * psigamma(alpha, 2) - 0.5e0 * alpha ^ 3 * psigamma(alpha, 2) + 0.5e0 * trigamma(alpha) * alpha ^ 4 + 0.5e0 * trigamma(alpha) * alpha ^ 3 - 0.1e1) / n / (trigamma(alpha + 1) * alpha + trigamma(alpha + 1) - 0.1e1) ^ 2 / alpha ^ 3
  bias.theta <- (0.1e1 + alpha ^ 5 * trigamma(alpha) ^ 2 + alpha ^ 4 * trigamma(alpha) ^ 2 - 0.2e1 * trigamma(alpha) * alpha ^ 2 - 0.5e0 * alpha ^ 5 * psigamma(alpha, 2) - 0.5e0 * alpha ^ 4 * psigamma(alpha, 2) + 0.5e0 * alpha ^ 2 - 0.2e1 * trigamma(alpha) * alpha ^ 3 - 0.15e1 * trigamma(alpha) * alpha ^ 4) * theta / n / (trigamma(alpha + 1) * alpha + trigamma(alpha + 1) - 0.1e1) ^ 2 / alpha ^ 4
  c(alpha = bias.alpha, theta = bias.theta)  
}

# Two-Parameter Weibull Distribution --------------------------------------
weibull.bc <- function(n, mle)
{
  scale <- mle[1]; shape <- mle[2]
  c(mu = scale*(-.3698145397*shape+.5543324495)/n/shape^2, beta = 1.379530692*shape/n)
}

# Two-Parameter Inverse Weibull Distribution ------------------------------
inverseweibull.bc <- function(n, mle)
{
  beta <- mle[1]; mu <- mle[2]
  c(beta = 1.379530690*beta/n, mu = mu / n / beta ^ 2 * (0.3698145391e0 * beta + 0.5543324494e0))
}

# Two-Parameter Generalized Half-Normal Distribution ----------------------
genhalfnormal.bc <- function(n, mle)
{
  alpha <- mle[1]; theta <- mle[2]
  c(alpha = 1.483794456 * alpha / n, theta = (0.2953497661 - 0.3665611957 * alpha) * theta / (n * alpha ^ 2))
}

# Two-Parameter Inv. Gen. Half Normal Distribution ------------------------
invgenhalfnormal.bc <- function(n, mle)
{
  alpha <- mle[1]; theta <- mle[2]
  c(alpha = (0.6777027624e-9 * log(theta) ^ 2 * alpha ^ 3 + (0.6180963939e-10 * alpha + 0.6696171236e-9 * alpha ^ 2) * log(theta) + 0.1483794458e1 * alpha + 0.1e-9) / n, theta = (0.9287154894e-9 * theta * alpha ^ 3 * log(theta) ^ 2 + 0.600427242e-10 * theta * (alpha + 0.2445875484e1) * alpha * log(theta) - 0.3665611948e0 * theta * (alpha - 0.8057311322e0)) / n / alpha ^ 2)
}

# Two-Parameter MOE-Exponential Distribution ------------------------------
moeexp.bc <- function(n, mle)
{
  dilog <- function(x)
  {
    integrand <- function(t) { }
    body(integrand) <- quote(log(t) / (1 - t))
    integrate(integrand, lower = 1, upper = x)$value
  }
  alpha <- mle[1]; lambda <- mle[2]
  b.alpha  =  ((-0.5999999998e1 * alpha ^ 5 + 0.5999999999e2 * alpha ^ 14 - 0.270e3 * alpha ^ 13 + 0.7199999999e3 * alpha ^ 12 - 0.5999999998e1 * alpha ^ 15 - 0.1260e4 * alpha ^ 11 + 0.1512e4 * alpha ^ 10 - 0.1260e4 * alpha ^ 9 + 0.7199999999e3 * alpha ^ 8 - 0.270e3 * alpha ^ 7 + 0.5999999999e2 * alpha ^ 6) * log(alpha) ^ 3 + ((0.3000000002e1 * alpha ^ 15 - 0.2400000003e2 * alpha ^ 14 + 0.6e1 * alpha ^ 4 - 0.5850000001e3 * alpha ^ 7 + 0.2400000003e3 * alpha ^ 6 - 0.57e2 * alpha ^ 5 + 0.504e3 * alpha ^ 10 - 0.882e3 * alpha ^ 9 + 0.900e3 * alpha ^ 8 + 0.750000001e2 * alpha ^ 13 - 0.900000003e2 * alpha ^ 12 - 0.899999996e2 * alpha ^ 11) * dilog(alpha) - 0.3464999998e3 * alpha ^ 5 - 0.2227499999e4 * alpha ^ 7 + 0.2673e4 * alpha ^ 10 - 0.3464999999e4 * alpha ^ 9 + 0.3266999999e4 * alpha ^ 8 - 0.1485e3 * alpha ^ 13 + 0.5775e3 * alpha ^ 12 - 0.1485e4 * alpha ^ 11 - 0.1500000002e1 * alpha ^ 15 + 0.225e2 * alpha ^ 14 + 0.10725e4 * alpha ^ 6 + 0.6749999997e2 * alpha ^ 4 - 0.5999999996e1 * alpha ^ 3) * log(alpha) ^ 2 + ((-0.12e2 * alpha ^ 15 + alpha ^ 14 * 0.127500000003534353e3 + alpha ^ 4 * 0.449999998292678285e2 + alpha ^ 2 * 0.150000000061133276e1 + alpha ^ 3 * (-0.120000000299494349e2) + alpha ^ 7 * (-0.118800000172904220e4) + alpha ^ 6 * 0.412499999276669314e3 + alpha ^ 5 * (-0.132000001083024245e3) + alpha ^ 10 * 0.430650000322067535e4 + alpha ^ 9 * (-0.396000000353064615e4) + alpha ^ 8 * 0.257400000129217869e4 + alpha ^ 13 * (-0.612000000142348995e3) + alpha ^ 12 * 0.174900000021882715e4 + alpha ^ 11 * (-0.330000000064775304e4)) * dilog(alpha) + alpha * (-0.149999999567912368e1) + alpha ^ 5 * (-0.197999999939499094e4) + alpha ^ 7 * (-0.487574999767996542e4) + alpha ^ 10 * 0.701249999008636792e3 + alpha ^ 9 * (-0.262349999756744592e4) + alpha ^ 8 * 0.445499999797365308e4 + alpha ^ 13 * 0.165000000081150631e3 + alpha ^ 12 * (-0.361500000228017711e3) + alpha ^ 11 * 0.272250000875105741e3 + 0.3750000001e1 * alpha ^ 15 + alpha ^ 14 * (-0.382499999980094074e2) + alpha ^ 6 * 0.370424999790608081e4 + alpha ^ 4 * 0.730499999779901827e3 + alpha ^ 3 * (-0.176249999850207701e3) + alpha ^ 2 * 0.247499999437890565e2) * log(alpha) + 0.6e1 * alpha * (-0.1e1 + alpha) ^ 14 * dilog(alpha) ^ 2 + (-0.6e1 * alpha ^ 15 + 0.102e3 * alpha ^ 14 + 0.6424500002e4 * alpha ^ 4 + 0.327e3 * alpha ^ 2 - 0.1785000002e4 * alpha ^ 3 - 0.345e2 * alpha - 0.4316400001e5 * alpha ^ 7 + 0.3062400001e5 * alpha ^ 6 - 0.163515e5 * alpha ^ 5 + 0.23331e5 * alpha ^ 10 - 0.378015e5 * alpha ^ 9 + 0.4628250001e5 * alpha ^ 8 - 0.7725e3 * alpha ^ 13 + 0.34995e4 * alpha ^ 12 - 0.10677e5 * alpha ^ 11 + 0.15e1) * dilog(alpha) - 0.15000001e1 * alpha + 0.5362500008e4 * alpha ^ 5 + 0.1480050001e5 * alpha ^ 7 - 0.7614750001e4 * alpha ^ 10 + 0.126555e5 * alpha ^ 9 - 0.1576575001e5 * alpha ^ 8 + 0.2235e3 * alpha ^ 13 - 0.106275e4 * alpha ^ 12 + 0.33735e4 * alpha ^ 11 + 0.15e1 * alpha ^ 15 - 0.2775e2 * alpha ^ 14 - 0.1040325001e5 * alpha ^ 6 - 0.1940250003e4 * alpha ^ 4 + 0.4485e3 * alpha ^ 3 - 0.502500012e2 * alpha ^ 2 + 0.74999998e0) / (alpha - 0.1000000000e1) ^ 8 / n / (log(alpha) ^ 2 * alpha ^ 3 + (-0.2e1 * alpha ^ 2 + 0.2e1 * alpha) * log(alpha) + 0.2e1 * (-0.1e1 + alpha) ^ 3 * dilog(alpha) - (-0.1e1 + alpha) ^ 2 * (alpha - 0.2e1)) ^ 2
  b.lambda =  -0.1e-8 * lambda * ((alpha ^ 6 * (-0.300000000173718071e10) + alpha ^ 11 * 0.629999999837897644e11 + alpha ^ 13 * 0.299999998799999952e10 + alpha ^ 14 + alpha ^ 10 * (-0.105000000032813965e12) + alpha ^ 9 * 0.105000000041518127e12 + alpha ^ 8 * (-0.630000000194516449e11) + alpha ^ 7 * 0.210000000011026917e11 + alpha ^ 12 * (-0.209999999824077911e11)) * log(alpha) ^ 3 + (0.5999999997e10 * alpha ^ 14 + alpha ^ 7 * (-0.594000000117675903e12) + alpha ^ 6 * 0.179999999969532867e12 + alpha ^ 5 * (-0.285000000013532219e11) + alpha ^ 4 * 0.149999999960561252e10 + alpha ^ 10 * 0.138600000035542285e13 + alpha ^ 9 * (-0.157500000047534521e13) + alpha ^ 8 * 0.119700000040507300e13 + alpha ^ 13 * (-0.644999999846007843e11) + alpha ^ 12 * 0.301499999942233948e12 + alpha ^ 11 * (-0.809999999963893066e12)) * log(alpha) ^ 2 + ((-0.630e12 * alpha ^ 7 + 0.3600000001e12 * alpha ^ 6 - 0.1350000002e12 * alpha ^ 5 + 0.30e11 * alpha ^ 4 - 0.2999999999e10 * alpha ^ 3 + 0.2999999996e11 * alpha ^ 12 - 0.135e12 * alpha ^ 11 + 0.3600000001e12 * alpha ^ 10 - 0.630e12 * alpha ^ 9 + 0.756e12 * alpha ^ 8 - 0.299999999e10 * alpha ^ 13 - 0.1e1 * alpha ^ 14) * dilog(alpha) + alpha ^ 3 * (-0.254999999424607048e11) + alpha ^ 7 * (-0.182699999557042798e13) + alpha ^ 9 * (-0.125099999842176831e13) + alpha ^ 12 * 0.254999999481371689e11 + alpha ^ 11 * (-0.163499999769655792e12) + alpha ^ 10 * 0.571499999218693848e12 - 0.1499999999e10 * alpha ^ 13 + alpha ^ 8 * 0.182699999687113379e13 + alpha ^ 6 * 0.125099999680627612e13 + alpha ^ 5 * (-0.571499998953846436e12) + alpha ^ 4 * 0.163499999786294708e12 + alpha ^ 2 * 0.149999999462343597e10) * log(alpha) + (-0.9504e13 * alpha ^ 7 + 0.6138e13 * alpha ^ 6 - 0.28875e13 * alpha ^ 5 + 0.5774999998e13 * alpha ^ 10 - 0.92565e13 * alpha ^ 9 + 0.10890e14 * alpha ^ 8 - 0.1425e12 * alpha ^ 13 + 0.7769999999e12 * alpha ^ 12 - 0.2573999999e13 * alpha ^ 11 + 0.12e11 * alpha ^ 14 + 0.957000001e12 * alpha ^ 4 + 0.2699999994e11 * alpha ^ 2 - 0.2099999998e12 * alpha ^ 3 - 0.1499999999e10 * alpha) * dilog(alpha) - 0.1e1 - 0.75e9 * alpha + 0.1061250002e13 * alpha ^ 5 + 0.3726000002e13 * alpha ^ 7 - 0.207375e13 * alpha ^ 10 + 0.345375e13 * alpha ^ 9 - 0.4194000001e13 * alpha ^ 8 + 0.4575e11 * alpha ^ 13 - 0.258e12 * alpha ^ 12 + 0.888e12 * alpha ^ 11 - 0.375e10 * alpha ^ 14 - 0.2387250002e13 * alpha ^ 6 - 0.300000001e12 * alpha ^ 4 + 0.419999998e11 * alpha ^ 3 + 0.75e9 * alpha ^ 2) / (alpha - 0.1000000000e1) ^ 6 / alpha ^ 2 / (log(alpha) ^ 2 * alpha ^ 3 + (-0.2e1 * alpha ^ 2 + 0.2e1 * alpha) * log(alpha) + 0.2e1 * (-0.1e1 + alpha) ^ 3 * dilog(alpha) - (-0.1e1 + alpha) ^ 2 * (alpha - 0.2e1)) ^ 2 / n
  c(alpha = b.alpha, lambda = b.lambda)
}

# Two-Parameter Beta Distribution -----------------------------------------
beta.bc <- function(n, mle)
{
  p <- mle[1]; q <- mle[2]
  bias.p <- -(0.5e0 * trigamma(p + q) ^ 2 * psigamma(p, 2) - trigamma(q) * trigamma(p + q) * psigamma(p, 2) - 0.5e0 * trigamma(q) ^ 2 * psigamma(p + q, 2) + 0.5e0 * trigamma(q) ^ 2 * psigamma(p, 2) - 0.5e0 * psigamma(p + q, 2) * trigamma(p) * trigamma(q) - 0.5e0 * trigamma(p + q) ^ 2 * psigamma(q, 2) + 0.5e0 * trigamma(p + q) * trigamma(p) * psigamma(q, 2)) * gamma(q) * gamma(p) / n / gamma(p + q) / ((trigamma(p) + trigamma(q)) * trigamma(p + q) - trigamma(p) * trigamma(q)) ^ 2 / beta(p, q)
  bias.q <- (0.5e0 * trigamma(p + q) ^ 2 * psigamma(p, 2) - 0.5e0 * trigamma(q) * trigamma(p + q) * psigamma(p, 2) + 0.5e0 * psigamma(p + q, 2) * trigamma(p) * trigamma(q) - 0.5e0 * trigamma(p + q) ^ 2 * psigamma(q, 2) + trigamma(p + q) * trigamma(p) * psigamma(q, 2) + 0.5e0 * trigamma(p) ^ 2 * psigamma(p + q, 2) - 0.5e0 * trigamma(p) ^ 2 * psigamma(q, 2)) * gamma(q) * gamma(p) / n / gamma(p + q) / ((trigamma(p) + trigamma(q)) * trigamma(p + q) - trigamma(p) * trigamma(q)) ^ 2 / beta(p, q)
  c(alpha = bias.p, beta = bias.q)
}

# Two-Parameter Beta Distribution ----------------------------------------- Gauss
beta.gauss.bc <- function(n, mle)
{
  p <- mle[1]; q <- mle[2]
  delta <- trigamma(p)*trigamma(q) - trigamma(p + q) * (trigamma(p) + trigamma(q))
  aux.p   <- psigamma(p + q, 2) * trigamma(q) * (trigamma(p) + trigamma(q)) - psigamma(p, 2) * (trigamma(p + q) - trigamma(q))^2
  + psigamma(q, 2) * trigamma(p + q) * (trigamma(p + q) - trigamma(p))
  
  aux.q   <- psigamma(q + p, 2) * trigamma(p) * (trigamma(q) + trigamma(p)) - psigamma(q, 2) * (trigamma(q + p) - trigamma(p))^2
  + psigamma(p, 2) * trigamma(q + p) * (trigamma(q + p) - trigamma(q))
  bias.p <- aux.p/(2*n*delta^2)
  bias.q <- aux.q/(2*n*delta^2)
  c(alpha = bias.p, beta = bias.q)
}

# Two-Parameter Kumaraswamy Distribution ----------------------------------
kum.bc <- function(n, mle)
{
  alpha <- mle[1]; beta <- mle[2]
  Ab  <- 1 + beta/(beta - 1) * ( (digamma(beta) - digamma(2))^2 - (trigamma(beta) - trigamma(2)))
  Bb  <- -1/(beta-1) * (digamma(beta + 1) - digamma(2))
  Cb  <- beta^2 * (trigamma(beta + 1) + Bb)
  Db  <- beta^3 * Bb *(2 * trigamma(beta)*(digamma(beta) - digamma(2)) - psigamma(beta, 2))
  Eb  <- (beta*(beta + 1)) / (2 * (beta - 2)) * ((digamma(beta) - digamma(1))^3 + (psigamma(beta,2) - psigamma(1,2)) - 3 * (trigamma(beta) - trigamma(1)) * (digamma(beta) - digamma(1)))
  Fb  <- (6 * beta) / (beta - 2) * (digamma(beta) - digamma(1)) 
  Gb  <- (3 * beta * (beta + 3))/ (2 * (beta - 2)) * ( (digamma(beta) - digamma(1))^2 - (trigamma(beta) - trigamma(1)))
  k   <- (Ab - beta^2*Bb^2)^2
  a0  <- -1 + 2 * Ab - beta * Bb * (2 * beta * Bb + Ab)
  a1  <- (beta^2 * Bb^2 + Ab) * Cb - 3 * beta^2 * Bb * (Ab - 1) / 2
  a2  <- Db - 2 * beta * Bb * (Ab - 1)
  a3  <- Gb - Fb - Eb
  b0  <- Ab * (Ab - beta * Bb) + beta * Bb * (beta ^ 2 * Bb ^ 2 + 1)
  b1  <- beta ^ 3 * Bb ^ 2 * (Ab - 1) - 2 * beta * Ab * Bb * Cb + beta * Ab * (Ab - 1) / 2
  b2  <- 2 * beta ^ 2 * Bb ^ 3 * (Ab - 1) - beta * Bb * Db
  b3  <- - beta * Bb * a3
  b.alpha <- (alpha / (n * k)) * (a0 + a1 / (beta - 1) + a2 / (beta - 2) + a3 / (beta - 3))
  b.beta  <- (beta / (n * k)) * (b0 + b1 / (beta - 1) + b2 / (beta - 2) + b3 / (beta - 3))
  c(alpha = b.alpha, beta = b.beta)
}

# Two-Parameter Inverse Beta Distribution ---------------------------------
invbeta.bc <- function(n, mle)
{
  p     <- mle[1]; q <- mle[2]
  delta <- trigamma(p) * (trigamma(q) - trigamma(p + q)) - trigamma(q) * trigamma(p + q)
  aux.p <- - (trigamma(p + q) * (trigamma(p + q) * (psigamma(p, 2) - psigamma(q, 2))) + trigamma(p) * psigamma(q, 2)) + (trigamma(q)^2) * (psigamma(p + q, 2) - psigamma(p, 2))
  + trigamma(q) * (2 * trigamma(p + q) * psigamma(p, 2) + trigamma(p) * psigamma(p + q, 2))
  aux.q <- trigamma(p + q) ^ 2 * (psigamma(p, 2) - psigamma(q, 2)) + 2 * trigamma(p) * trigamma(p + q) * psigamma(q, 2) * trigamma(p) ^ 2 * (psigamma(p + q, 2) - psigamma(q, 2))
  + trigamma(q) * (- (trigamma(p + q) * psigamma(q, 2)) + trigamma(p) * psigamma(p + q, 2))
  bias.p <- aux.p / (2 * n * delta ^ 2)
  bias.q <- aux.q / (2 * n * delta ^ 2)
  c(alpha = bias.p, beta = bias.q)
}

# Two-Parameter Birnbaum-Saunders Distribution ----------------------------
birnbaumsaunders.bc <- function(n , mle)
{
  alpha <- mle[1]; beta <- mle[2]
  h <- function(alpha)
  {
    alpha * sqrt(pi / 2) - pi * exp(2 / (alpha ^ 2)) * (1 - pnorm(2 / alpha))
  }
  balpha <- - alpha / (4 * n) * (1 + (2 + alpha ^ 2) / (alpha * (2 * pi) ^ (-0.5) * h(alpha) + 1 )  )
  bbeta  <- beta * alpha ^ 2 / (2 * n * (alpha * (2 * pi) ^ (-0.5) * h(alpha) + 1))
  c(alpha = balpha, beta = bbeta)
}
