# ------------------------------------------------------------------------------
# Replication material for:
#    Simulate Probabilistic Long-Term Effects in Models with Temporal
#    Dependence
# Christopher Gandrud and Laron K Williams
# 2017-06-26
# ------------------------------------------------------------------------------

## Load packages
library(pltesim)
library(ggplot2)

# Load simulated data
data("negative_year", package = "pltesim")

# Generate spells for binary variables
neg_set <- pltesim::btscs(df = negative_year, event = "y", t_var = "year",
                          cs_unit = "group")

# Estimate logistic model parameters
m1 <- glm(y ~ x + spell_time + I(spell_time^2) + I(spell_time^3),
          family = binomial(link = "logit"), data = neg_set)

# Create change in x
x_change <- data.frame(x = 0.5)

# Simulate and plot one-period change
sim1 <- plte_builder(obj = m1, obj_tvar = "spell_time",
                     cf_duration = "one-time",
                     cf = x_change, t_points = c(13, 25))

plte_plot(sim1) +
    scale_y_continuous(limits = c(0, 0.4))

# Simulate and plot permanent change
sim2 <- plte_builder(obj = m1, obj_tvar = "spell_time",
                     cf = x_change,
                     cf_duration = "permanent",
                     t_points = c(13, 25))

plte_plot(sim2) +
    scale_y_continuous(limits = c(0, 0.4))

# Simulate and plot four period change in x
sim3 <- plte_builder(obj = m1, obj_tvar = "spell_time",
                     cf_duration = 4,
                     cf = x_change,
                     t_points = c(13, 25))

plte_plot(sim3) +
    scale_y_continuous(limits = c(0, 0.4))

# Simulate and plot multiple events and permanent increase in x
sim4 <- plte_builder(obj = m1, obj_tvar = "spell_time",
                    cf = x_change,
                    t_points = c(13, 20, 25))
plte_plot(sim4) +
    scale_y_continuous(limits = c(0, 0.4))
