# {{{ Article

# {{{  Introduction
# S1
library(riskRegression, verbose = FALSE, quietly = TRUE)
library(survival)
data(Melanoma)
str(Melanoma)
# }}}

# {{{ Predicting absolute risks based on cause-specific Cox regression
# S2
cfit0 <- CSC(formula=Hist(time,status)~age+logthick+epicel+strata(sex),
	     data=Melanoma)
coef(cfit0)

# S3
s <- with(Melanoma,survival::Surv(time,status))

# S4
h <- with(Melanoma,prodlim::Hist(time,status))
h

# S5
plot(h,arrowLabelStyle="count",stateLabels=c("Radical\noperation","Cancer\nrelated death","Death\nother causes"))

# S6
cfit1 <- CSC(formula=list(Hist(time,status)~age+logthick+epicel+strata(sex),
			  Hist(time,status)~age+strata(sex)),
	     data=Melanoma)
coef(cfit1)

# S7
newdata <- data.frame(age=c(45,67), logthick=c(0.1,0.2), epicel=c("present","not present"), sex=c("Female","Male"))
pfit1 <- predict(cfit1,newdata=newdata,cause=1,times=c(867,3500))

# S8
print(pfit1)

# S9
pfit1se <- predict(cfit1,newdata=newdata,cause=1,times=c(867,3500),
		   se=TRUE,keep.newdata=FALSE)
print(pfit1se)

# S10
str(pfit1se)

# S11
ptable1 <- as.data.table(pfit1se)
ptable1[times==3500&observation==1,.(times,absRisk,absRisk.lower,absRisk.upper)]

# S12
vec.times <- cfit1$eventTimes
pfit1band <- predict(cfit1,newdata=newdata[1],cause=1,
		     times=vec.times,se=TRUE,band=TRUE)
newdata[1]

# S13
resGG <- autoplot(pfit1band, band = TRUE, ci = TRUE)$plot + xlab("time (in days)")
print(resGG)

# S14
class(resGG)
# }}}

# {{{ Construction of the confidence intervals
# S15
pfit2se <- predict(cfit1,newdata=newdata,cause=1,times=c(867,3500),
		   se=TRUE,logTransform=TRUE,keep.newdata=FALSE)
print(pfit2se)
# }}}

# {{{ Implementation details
# S16
f1 <- coxph(Surv(time,status==1)~age+logthick+epicel+strata(sex),data=Melanoma,x=TRUE,y=TRUE)
f1$method

# S17
baseH1 <- predictCox(f1)
as.data.table(baseH1[c("time","hazard","cumhazard","strata","survival")])

# S18
predictCox(f1,newdata=Melanoma[c(17,101,123),],times=c(7,3,5)*365.25)

# S19
f1 <- coxph(Surv(time,status==1)~age+logthick+epicel+strata(sex),
	    data = Melanoma,x = TRUE, y = TRUE)
f1.iid <- iidCox(f1)
lapply(f1.iid$IFcumhazard, dim)

# S20
f2.iid <- iidCox(f1, store.iid = "minimal")
str(f2.iid$calcIFhazard)

# S21
pfit3se <- predict(cfit1,newdata=newdata,cause=1,times=c(867,3500),
		   se=TRUE, store.iid="minimal", keep.newdata = FALSE)
print(pfit3se)

range(pfit3se$absRisk.se-pfit1se$absRisk.se)
range(pfit3se$absRisk.upper-pfit1se$absRisk.upper)
range(pfit3se$absRisk.lower-pfit1se$absRisk.lower)

# S22
p1 <- predictCox(f1, newdata = Melanoma[3:5,], 
		 times = c(Melanoma$time[5:7],1000),
		 se = TRUE, type="survival")

# S23
print(p1)

# S24
p1 <- as.data.table(p1)
p1[times==185,]
# }}}

# {{{ Runtime and memory usage
# S25
Surv(time,event)~strata(X1)+X2+X3+X4+X5+X6+X7+X8+X9+X10

# S26
Surv(time,event)~X1+X2+X3+X4+X5+X6+X7+X8+X9+X10
# }}}

# {{{ Appendix A

# S27
library(mets, verbose = FALSE)
Melanoma$entry <- 0
f1.phreg <- phreg(Surv(entry, time, status == 1) ~ age + logthick + epicel + 
		      strata(sex), data = Melanoma)
list(coxph=names(f1),
     phreg=names(f1.phreg))

# S28
riskRegression:::CoxCenter.coxph(f1)

# S29
head(riskRegression:::CoxDesign.coxph(f1))

# S30
riskRegression:::CoxFormula.coxph(f1)

# S31
head(riskRegression:::CoxLP.coxph(f1, data = NULL, center = FALSE))

# S32
riskRegression:::CoxN.coxph(f1)

# S33
riskRegression:::CoxSpecialStrata.coxph(f1)

# S34
head(riskRegression:::CoxStrata.coxph(f1, data = NULL, stratavars = "strata(sex)"))

# S35
riskRegression:::CoxVarCov.coxph(f1)

# S36
riskRegression:::CoxVarCov.coxph

# S37
all.equal(predictCox(f1),predictCox(f1.phreg))

# S38
all.equal(iidCox(f1),iidCox(f1.phreg))
# }}}


#----------------------------------------------------------------------
### AllCox.R ends here
