library(carx)
library(xts)

#code to reproduce "A step-by-step illustration with a simulated series"
datSim = carxSimCenTS(seed = 0,end.date = as.Date('2015-08-01'))
tail(datSim)

pdf("carxjss-plot-sim-data.pdf",width=8,height=6,page="special")
plot(datSim)
dev.off()

modelSim <- carx(y ~ X1 + X2 - 1,data = datSim, p = 2, CI.compute = TRUE)
modelSim
summary(modelSim)
logLik(modelSim)
coef(modelSim)
modelSim$sigma

pdf("carxjss-plot-sim-data-fitted.pdf",width=8,height=6,page="special")
plot(modelSim)
dev.off()

pdf("carxjss-plot-tsdiag-sim-data.pdf",width=8,height=10,page="special")
tsdiag(modelSim)
dev.off()


#code to reproduce "A real data application"

names(pts)

#plot-real-data-orig
library(xts)
pdf("carxjss-plot-real-data-orig.pdf",width=8,height=6,page="special")
par(new=FALSE)
par(mar=c(5,4,4,5)+.1)
plot(exp(pts),type="l",xlab="Time",ylab="P",main="",auto.grid=FALSE)
par(new=TRUE)
plot(xts(exp(pts$logQ),index(pts)),type="l",col="blue",lty=3, pch=8, main="",
     minor.ticks = F, xaxt="n",yaxt="n",xlab="",ylab="",auto.grid=FALSE)
axis(4,col="blue",col.axis="blue")
mtext("Q",side=4,line=3)
legend("topright",col=c("black","red","blue"),lty=c(1,3,3),lwd=c(1,1,2),
       legend=c("P","Lower censor limit", "Q"),cex=1)
dev.off()


#plot-real-data-by-season
pdf("carxjss-plot-real-data-by-season.pdf",width=8,height=6,page="special")
plot(coredata(pts)[,'logQ'],coredata(pts)[,'logP'],xlab="log(Q)",ylab="log(P)",type='n',main="")
for(i in 1:4)
{
  lP <- coredata(pts)[,'logP'][coredata(pts)[,'season']==i]
  lQ <- coredata(pts)[,'logQ'][coredata(pts)[,'season']==i]
  
  if (length(lP) != 0)
  {
    text(lQ,lP,label=i,col=i)
    m <- lm(lP~lQ)
    abline(m,lty=i,col=i,lwd=2)
  }
}
dev.off()


arOrder <- 3

s1 <- logP ~ logQ
s2 <- logP ~ tInMonth + logQ
s3 <- logP ~ logQ:as.factor(season)
s4 <- logP ~ tInMonth + logQ:as.factor(season)
s5 <- logP ~ as.factor(season) + logQ - 1
s6 <- logP ~ tInMonth + as.factor(season) + logQ - 1
s7 <- logP ~ as.factor(season) + logQ:as.factor(season) - 1
s8 <- logP ~ tInMonth + as.factor(season) +  logQ:as.factor(season) - 1
fmls <- c(s1,s2,s3,s4,s5,s6,s7,s8)
names(fmls) <- paste0('M',seq(1,8))


cs <- carxSelect(fmls, arOrder, data = pts['1998/2012'], detect.outlier = TRUE, CI.compute = F)

print(round(cs$selectionInfo$aicMat,1))
summary(cs)

pdf("carxjss-plot-modelRD.pdf",width=8,height=6,page="special")
plot(cs)
dev.off()


pdf("carxjss-tsdiag-modelRD.pdf",width=8,height=10,page="special")
tsdiag(cs)
dev.off()

pts2 <- pts['2013']
pred <- predict(cs,newxreg=pts2,n.ahead=dim(pts2)[1])

pdf("carxjss-pred-modelRD.pdf",width=8,height=6,page="special")
plot(pts2,main='log(P) with Predicted Value',ylim=range(pts2[,c('logP','lcl')],pred$fitted,pred$ci))
lines(.index(pts2),pred$fit,col='blue',lty=2)
lines(.index(pts2),pred$ci[,1],col='red',lty=3)
lines(.index(pts2),pred$ci[,2],col='red',lty=4)
dev.off()

# code to reproduce "A simulation study on  model selection"
singleTestSelectAROrder <- function(iter)
{
  seed <- 1375911
  cts <- carxSim(seed = iter*seed)
  m0 <- carxSelect(list(f1 = as.formula(y~X1+X2-1)), max.ar = 6, 
                   data=cts[,c("y","X1","X2")],detect.outlier = FALSE)
  m1 <- carxSelect(list(f1 = as.formula(y~X1+X2-1)),max.ar = 6, 
                   data = cts, detect.outlier = FALSE)
  c(m0$fitted$p, m1$fitted$p)
}

nRep <- 1000
orders <- parallel::mclapply( 1:nRep, singleTestSelectAROrder,
                              mc.cores = parallel::detectCores() - 1)
orders <- do.call(rbind, lapply(orders, matrix, ncol = 2, byrow = TRUE))
freqComDat = count(orders[1,])
freqCenDat = count(orders[2,])


require(xtable)
arOrder = seq(1,6)
#freqCenDat =  c(17, 626, 139, 96, 66, 54)
#freqComDat = c(34, 536, 158, 103, 87, 82)
aicSel = matrix(c(arOrder,freqCenDat$freq,freqComDat$freq),byrow=TRUE,nrow=3)
rownames(aicSel) = c('AR order', 
                     'Frequency (censored data)', 
                     'Frequency (complete data)'
)
aicSelTable = xtable(aicSel, 
                     caption='Summary of selected orders. The frequency of selected orders with censored data and completed data are reported.',
                     label='tab:selection',
                     digits=0)
print(aicSelTable, 
      floating=TRUE,
      include.colnames=FALSE)


#code to reproduce "Performance of model prediction"

nRep = 500; nObs = 200; n.ahead=10
saveDir = './testPredictCR_rslt'
dir.create(saveDir,showWarnings=FALSE,recursive=TRUE)
crPredFile = paste0(saveDir,'/crPred.RData')

runSimPredCR <- function()
{
  set.seed(0)
  crMat = matrix(nrow = n.ahead, ncol = nRep)
  for(iRep in 1:nRep)
  {
    sdata = carxSim(nObs = nObs + n.ahead)
    trainingData = sdata[1:nObs,]
    testData = sdata[-(1:nObs),]
    mdl = carx(y ~ X1 + X2 - 1, data = trainingData, p = 2)
    newxreg = testData[,c('X1','X2')]
    predVal = predict(mdl, newxreg = newxreg, n.ahead = n.ahead)
    crInd = (predVal$ci[,1] <= testData$y) & (predVal$ci[,2] >= testData$y)
    crMat[,iRep] = crInd
  }
  crPred = apply(crMat,1,mean)
}
runSimPredCR()

require(xtable)
crPredTable = rbind(c(1:n.ahead),crPred)
rownames(crPredTable) = c('n.ahead','Empirical Coverage')
xtab<-xtable(crPredTable,
             caption='Empirical coverage rates of nominally 95\\% predictive confidence intervals for $\\ell$-step-ahead prediction, for $\\ell=1,2,\\ldots, 10$.',
             label='tab:pred-cr',
             align='lcccccccccc',
             digits=matrix(c(0,rep(0,n.ahead),0,rep(3,n.ahead)),nrow=2,byrow=TRUE))
print(xtab, 
      floating=TRUE,
      include.colnames=FALSE)

