#rm(list=ls())

#ITT analysis
library(rpsftm)
library(eha)
itt_fit <- aftreg(Surv(progyrs, prog) ~ imm, data = immdef)
itt_fit

# Example

head(immdef)
rx <- with(immdef, 1 - xoyrs/progyrs)
rpsftm_fit_lr <- rpsftm(formula=Surv(progyrs, prog) ~ rand(imm, rx),
                        data=immdef,
                        censor_time=censyrs)
summary(rpsftm_fit_lr)
plot(rpsftm_fit_lr)

#Cox PH model
rpsftm_fit_cph <- rpsftm(formula=Surv(progyrs, prog) ~ rand(imm, rx) + entry,
                         data=immdef,
                         censor_time=censyrs,
                         test=coxph)
summary(rpsftm_fit_cph)


#Weibull model
rpsftm_fit_wb <- rpsftm(formula=Surv(progyrs, prog) ~ rand(imm, rx) + entry,
                         data=immdef,
                         censor_time=censyrs,
                         test=survreg)
summary(rpsftm_fit_wb)

#sensitivity analysis

weight <- with(immdef, ifelse(imm==1, 1, 0.5))
rpsftm( Surv( progyrs, prog) ~ rand( imm, rx), data = immdef, censor_time = censyrs,
          treat_modifier = weight)

#trouble shooting

rpsftm(formula=Surv(progyrs, prog) ~ rand(imm, rx),
       data=immdef,
       censor_time=censyrs,
       low_psi=-1,
       hi_psi=-0.9)

rpsftm_fit <- rpsftm(formula=Surv(progyrs, prog) ~ rand(imm, rx),
                      data=immdef,
                      censor_time=censyrs,
                      low_psi=-1,
                      hi_psi=-0.1)

plot(rpsftm_fit$eval_z, type="s", ylim=c(-2, 6))
abline(h=qnorm(c(0.025, 0.5, 0.975)))
abline(v=rpsftm_fit$psi)
abline(v=rpsftm_fit$CI)
