###############################################################################
# cchs_RJournal_replicationMaterial.R
# Replication material for 
# "cchs: An R Package for Stratified Case-Cohort Studies". 
# This has been run in R 3.2.3 on Windows 7 and in R 3.3.0 on Windows 10.

#install.packages(cchs)  # if necessary
library(cchs)

###############################################################################
##### "An example analysis" #####

# These two commands produce the output that is shown in this section.
set.seed(1)
cchs(Surv(time, isCase) ~ ageAtDiagnosis + stage, data = cchsData,
      inSubcohort = inSubcohort, stratum = localHistol, 
      samplingFractions = sampFrac, precision = 1)

# These two commands appear in the text but their output is not shown.
result <- cchs(Surv(time, isCase) ~ ageAtDiagnosis + stage, data = cchsData,
      inSubcohort = inSubcohort, stratum = localHistol, 
      samplingFractions = sampFrac, precision = 1)
result$coeffsTable["ageAtDiagnosis", c("CIlower", "CIupper")]

###############################################################################
##### "Other issues for the user" #####

# This code creates Figure 1 as a PDF. 

# Do cchs lots of times. This is for the boxes and whiskers. 
n <- 1000
set.seed(2)
coeffs <- replicate(n = n, expr = cchs(Surv(time, isCase) ~ ageAtDiagnosis + 
      stage, data = cchsData, inSubcohort = inSubcohort, stratum = localHistol, 
      samplingFractions = sampFrac, precision = 1)$coefficients)

# Redo the cchs call from the previous section. This is for the points and 
# lines.  
set.seed(1)
cchsResult <- cchs(Surv(time, isCase) ~ ageAtDiagnosis + stage, data = cchsData,
      inSubcohort = inSubcohort, stratum = localHistol, 
      samplingFractions = sampFrac, precision = 1)

# A function to draw a horizontal box-and-whisker in which the box shows 
# the quartiles and the whiskers show the full range. 
horizontalBoxplot <- function(numbers, y) {
   height <- 0.7
   # Vertical lines:
   for (q in seq(0, 1, by = 0.25))
      lines(x = rep(quantile(numbers, q), 2), y = y + c(-1,1) * height / 2)
   # Horizontal lines:
   lines(x = quantile(numbers, c(0, 0.25)), y = rep(y, 2))
   lines(x = quantile(numbers, c(0.75, 1)), y = rep(y, 2))
   lines(x = quantile(numbers, c(0.25, 0.75)), y = rep(y - height / 2, 2))
   lines(x = quantile(numbers, c(0.25, 0.75)), y = rep(y + height / 2, 2))
}

# Set up the PDF. 
pdf(file = "fig.pdf", width = 8, height = 4)

# Draw the axes etc. 
par(mar = c(5, 5, 1, 0.5))
plot(NA, log = "x", ylim = c(0, 8), xlim = c(1, 4), axes = FALSE, 
      xlab = "hazard ratio", ylab = "")
axis(1, at = pretty(c(1, 4), n = 10))
axis(2, line = 3.5, las = 2, lwd = 0, hadj = 0, 
      at = rev(seq(1.5, by = 2, length.out = nrow(coeffs))), 
      labels = rownames(coeffs))
  
# Draw the boxes and whiskers and the points and lines.
hr <- exp(coeffs)
for (i in 1:nrow(hr)) {
   horizontalBoxplot(hr[i,], 2 * nrow(hr) - i * 2 + 1.1)
   yForPointsAndLines <- 2 * nrow(hr) - i * 2 + 1.9
   points(x = cchsResult$coeffsTable[i, "HR"], y = yForPointsAndLines, pch = 19)
   lines(x = cchsResult$coeffsTable[i, c("CIlower", "CIupper")], 
         y = rep(yForPointsAndLines, 2))
}

# Close the PDF.
dev.off()

###############################################################################
