#install.packages("InfoTrad")
library(InfoTrad)


# Sample Data
#   Buy Sell 
#1  350  382  
#2  250  500  
#3  500  463  
#4  552  550  
#5  163  200  
#6  345  323  
#7  847  456  
#8  923  342  
#9  123  578  
#10 349  455 

Buy<-c(350,250,500,552,163,345,847,923,123,349)
Sell<-c(382,500,463,550,200,323,456,342,578,455)
data=cbind(Buy,Sell)

# Initial parameter values
# par0 = (alpha, delta, mu, epsilon_b, epsilon_s)
par0 = c(0.5,0.5,300,400,500)



######################### EHO() #################################
# Call EHO likelihood factorization
LK_out_EHO = EHO(data)
modelEHO = optim(par0, LK_out_EHO, gr = NULL, method = c("Nelder-Mead"), hessian = FALSE)

# The structure of the model output with EHO factorization
modelEHO

## Parameter Estimates w/ EHO factorization
modelEHO$par[1] # Estimate for alpha
modelEHO$par[2] # Estimate for delta
modelEHO$par[3] # Estimate for mu
modelEHO$par[4] # Estimate for eb
modelEHO$par[5] # Estimate for es


## Estimate for PIN w/ EHO factorization
(modelEHO$par[1]*modelEHO$par[3])/((modelEHO$par[1]*modelEHO$par[3])+modelEHO$par[4]+modelEHO$par[5])


######################### LK() #################################
# Call LK likelihood factorization
LK_out_LK = LK(data)
modelLK = optim(par0, LK_out_LK, gr = NULL, method = c("Nelder-Mead"), hessian = FALSE)

## The structure of the model output with LK factorization
modelLK

## Parameter Estimates w/ LK factorization
modelLK$par[1] # Estimate for alpha
modelLK$par[2] # Estimate for delta
modelLK$par[3] # Estimate for mu
modelLK$par[4] # Estimate for eb
modelLK$par[5] # Estimate for es


## Estimate for PIN w/ LK factorization
(modelLK$par[1]*modelLK$par[3])/((modelLK$par[1]*modelLK$par[3])+modelLK$par[4]+modelLK$par[5])


######################### YZ() #################################
# Parameter estimates using the LK factorization of Lin and Ke (2011) 
# with the algorithm of Yan and Zhang (2012).
# Default factorization is set to be "LK"
YZ(data)

# Parameter estimates using the EHO factorization of Easley et. al. (2010) 
# with the algorithm of Yan and Zhang (2012).
YZ(data,likelihood="EHO")

######################### GAN() #################################
# Parameter estimates using the LK factorization of Lin and Ke (2011) 
# with the algorithm of Gan et. al. (2015).
# Default factorization is set to be "LK"
GAN(data)

# Parameter estimates using the EHO factorization of Easley et. al. (2010) 
# with the algorithm of Gan et. al. (2015)
GAN(data, likelihood="EHO")

######################### EA() #################################
# Parameter estimates using the LK factorization of Lin and Ke (2011) 
# with the modified clustering algorithm of Ersan and Alici (2016).
# Default factorization is set to be "LK"
EA(data)

# Parameter estimates using the EHO factorization of Easley et. al. (2010) 
# with the modified clustering algorithm of Ersan and Alici (2016).
EA(data,likelihood="EHO")

