## example 1
library(PanJen) 
data("hvidovre")
formBase<-formula(lprice ~brick+roof_tile+roof_cemen
                    + rebuild70+rebuild80+rebuild90+rebuild00+y7+y8+y9) 

summary(gam(formBase, method="GCV.Cp",data=hvidovre))



## example 2
PanJenArea<-fform(hvidovre,"area",formBase) 


## example 3
plotff(PanJenArea) 

## eaxmple 4
fx <- list( linear = function(x) x, sqr = function(x) x^2,  log= function(x) log(x))
PanJenAreaC<-choose.fform(data=hvidovre,variable="area",base_form=formBase,functionList=fx)
plotff(PanJenAreaC)


## example 5
hvidovre$larea<-log(hvidovre$area)
formArea<-formula(lprice ~brick+rebuild80+rebuild90+rebuild00+y7+y8+y9+larea)
summary(lm(formArea, data=hvidovre))


## example 6
PanJenAge<-fform(data=hvidovre,variable="age",base_form=formArea)
plotff(PanJenAge)

## example 7
names(PanJenArea$models)
## getting the variable names used in the log model transformation
namesVariables<-all.vars(formula(PanJenArea$models[["model_log(x)"]]))[1:11]
## creating a prediction dataframe with median values 
pred_frame<-data.frame(matrix(rep(sapply(hvidovre[namesVariables],median),each=100),nrow=100))
## giving the prediction dataframe variable names
names(pred_frame)<-namesVariables

## Finding the 0.05 quantile and the 0.95 quantile of the area variable
min05<-as.numeric(quantile(hvidovre$area,0.05))
max95<-as.numeric(quantile(hvidovre$area,0.95))

## Create prediction scale from  0.05 quantile to the 0.95 percentile
pred_frame$area<-seq(min05,max95,length.out=100)

## predicting  lprice using the prediction dataframe 
pred_frame$var<-log(pred_frame$area)
pred_frame$lprice=predict(PanJenArea$models[["model_log(x)"]],newdata=pred_frame, type="response")

## Defining limits for plot 
limx=c(min(pred_frame$area),max(pred_frame$area))
limy=c(min(pred_frame$lprice),max(pred_frame$lprice))


## Start plot
plot(pred_frame$lprice~pred_frame$area, data=pred_frame, type="l",sub="",
xlab="area",ylab="log(price)", lwd=3, col="black", xlim=limx, ylim=limy,  main="Price of living area") 

## create legend
legend(80,limy[2] , cex=1,lty=1,  "log(x)",  horiz=FALSE) 