install.packages("mopa")
library(mopa)

# IMPUT DATA PRE-PROCESSING

destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

data(Oak_phylo2)
help(Oak_phylo2)
presences <- Oak_phylo2$H11 
bg <- backgroundGrid(raster = biostack$baseline$bio1)
bg.subdomain <- backgroundGrid(raster = biostack$baseline$bio1, 
                                 spatial.subset = extent(c(-10, 35, 45, 65)))

bg.species <- backgroundGrid(raster = biostack$baseline$bio1, 
                               spatial.subset = presences)

# PSEUDO-ABSENCE GENERATION

# Random Sampling (RS)
pa_RS <- pseudoAbsences(xy = presences, background = bg$xy, 
                          realizations = 10, exclusion.buffer = 0.249,
                          prevalence = -0.5)
pa_kmeans <- pseudoAbsences(xy = presences, background = bg$xy, 
                              exclusion.buffer = 0.249,
                              prevalence = -0.5, 
                              kmeans = TRUE, varstack = biostack$baseline) 

# Random Sampling with Environmental Profiling (RSEP)
bg.profiled <- OCSVMprofiling(xy = presences, varstack = biostack$baseline, 
                                background = bg$xy)
pa_RSEP <- pseudoAbsences(xy = presences, background = bg.profiled$absence, 
                            realizations = 10, exclusion.buffer = 0.249,
                            prevalence = -0.5)  

# Three-step method (TS)
bg.radius <- backgroundRadius(xy = presences, background = bg.profiled$absence, 
                                 start = 0.249, by = 0.249, unit = "decimal degrees")
pa_TS <- pseudoAbsences(xy = presences, background = bg.radius, 
                           realizations = 10, exclusion.buffer = 0.249,
                           prevalence = -0.5)   


# Generates Fig. 1
  par(mfrow = c(2, 2), mar = c(2, 2, 2, 1.2))
# Panel 1a (Presence data)
  plot(bg$xy, pch = 18, cex = 0.4, col = "gray", asp = 1)
points(presences, pch = 18, cex = 0.6, col = "red")
# Panel 1b (RS method)
  plot(bg$xy, pch = 18, cex = 0.4, col = "gray", asp = 1)
points(pa_RS$species1$PA01[[1]], pch = 18, col = "darkviolet", cex = .6)

points(pa_kmeans$species1$PA01[[1]], pch = 18, col = "yellow", cex = .6)
points(presences, pch = 18, cex = 0.6, col = "red")
# Panel 1c (RSEP method)
  plot(bg.profiled$absence, pch = 18, cex = 0.4, col = "gray", asp = 1)
points(bg.profiled$presence, pch = 18, cex = 0.4, col = "aquamarine")
points(pa_RSEP$species1$PA01[[1]], pch = 18, cex = 0.6, col = "darkviolet")
points(presences, pch = 18, cex = 0.6, col = "red")
# Panel 1d (TS method)
  plot(bg.radius[[1]]$km3120, col = "gray", asp = 1, pch = 18, cex = 0.4)
points(bg.profiled$presence, pch = 18, cex = 0.4, col = "aquamarine")
for (i in 1:10) {
  l <- (11 - i) * 10
  points(bg.radius[[1]][[l]], 
         col = gray.colors(10, start = .9,end = 0.1)[i], 
         pch = 18, cex = 0.4)
}
points(pa_TS$species1$PA01[[50]], pch = 18, cex = 0.6, col = "darkviolet")
points(presences, pch = 18, cex = 0.6, col = "red")


#SDM FITTING AND PREDICTION

# Train model with RS pseudo-absences
trainRS <- mopaTrain(y = pa_RS, x = biostack$baseline, weighting = TRUE, 
                       k = 10, algorithm = c("glm", "mars"))

# The special case of model fitting with TS pseudo-absences
# Train model with TS pseudo-absences and generate Fig. 2. 
# The following example takes a long time because of the "weighting" type of the "mars" algorithm.
# Alternatively, in order to test the "mopaTrain" function with "Three--step" pseudo-absences, the same example 
# could be executed but setting argument "weighting" to FALSE. 
trainTS <- mopaTrain(y = pa_TS, x = biostack$baseline, weighting = TRUE, 
                         k = 10, algorithm = c("glm", "mars"), diagrams = TRUE)

# Model assessment
tss.RS <- extractFromModel(models = trainRS, value = "tss")
  
ObsPred.RS <- extractFromModel(models = trainRS, value = "ObsPred")
models.RS <- extractFromModel(models = trainRS, value = "model")

# Model predictions
ensemble.present <- mopaPredict(models = models.RS, newClim = biostack$baseline)
ensemble.future <- mopaPredict(models = models.RS, newClim = biostack$future)

# EXPLORING THE UNCERTAINTY IN SDM PROJECTIONS
rcms_run1 <- extractFromPrediction(ensemble.future, "PA01")
runs_rcm1 <- extractFromPrediction(ensemble.future, "MPI")
  
glm_runs_rcm1 <- extractFromPrediction(runs_rcm1, "glm")
# Generates Fig. 3
data(wrld)
spplot(glm_runs_rcm1, layout = c(5, 2),
           at = seq(0, 1, 0.1),
           col.regions = colorRampPalette(c("white",  "red3")),
           sp.layout= list(wrld, first = FALSE, lwd = 0.5))

# Partition of the uncertainty into components using ANOVA
var.glm <- varianceAnalysis(predictions = ensemble.future, 
                                component1 = "PA", component2 = "newClim", 
                                fixed = c("glm"))
# Generates Fig. 4              
spplot(var.glm$mean, 
             at = seq(0,1,0.1), 
             col.regions = colorRampPalette(c("white", "red3")),
             sp.layout= list(wrld, first = FALSE, lwd = 0.5))
# Generates Fig. 5              
spplot(var.glm$variance, 
             col.regions = rev(gray.colors(10, end = 1)), 
             at = seq(0, 100, 10), 
             sp.layout= list(wrld, first = FALSE, lwd = 0.5))
  
var.mars <- varianceAnalysis(predictions = ensemble.future, 
                                 component1 = "PA", component2 = "newClim", 
                                 fixed = c("mars"))
# Generates Fig. 6  
spplot(var.mars$mean, 
              at = seq(0,1,0.1), 
              col.regions = colorRampPalette(c("white", "red3")),
              sp.layout= list(wrld, first = FALSE, lwd = 0.5))
# Generates Fig. 7
spplot(var.mars$variance, 
             at = seq(0, 100, 10), 
             col.regions = rev(gray.colors(10, end = 1)), 
             sp.layout= list(wrld, first = FALSE, lwd = 0.5))

# Generates Fig. 8
varianceSummary("glm" = var.glm, "mars" = var.mars,
                  component = 2L, regions = c(6, 6), drawBoxplot = TRUE)


regiondir <- tempfile()
download.file("https://github.com/SantanderMetGroup/visualizeR/raw/devel/data/PRUDENCEregions.rda",
  destfile = regiondir)
load(regiondir)
varianceSummary("glm" = var.glm, "mars" = var.mars,
                  component = 2L, drawBoxplot = FALSE,
                  regions = PRUDENCEregions)


MPI.var <- varianceAnalysis(ensemble.future, 
                                component1 = "PA", 
                                component2 = "SDM", 
                                fixed = c("MPI"))
help(varianceAnalysis)

# SDM ENSEMBLE BUILDING 
marsEns <- extractFromPrediction(ensemble.future, value = "mars")
marsEnsPA08 <- extractFromPrediction(marsEns, value = "PA08")
glmEns <- extractFromPrediction(ensemble.future, value = "glm")

ensemble.future.def <-  stack(list(glmEns, marsEnsPA08))
mean.ensemble <- stackApply(ensemble.future.def, fun = mean, 
                                indices = rep(1, nlayers(ensemble.future.def)))
sd.ensemble <- stackApply(ensemble.future.def, fun = sd, 
                              indices = rep(1, nlayers(ensemble.future.def)))
forecast.future <- stack(mean.ensemble, sd.ensemble)
names(forecast.future) <- c("ensemble mean", "ensemble sd")
# Generates Fig. 8
spplot(forecast.future, at = seq(0,1,0.1), 
           col.regions = colorRampPalette(c("white", "red3")),
           sp.layout= list(wrld, first = FALSE, lwd = 0.5))


