#==================================
#Chapter 3.1 Example
#==================================
### Toy Example ### 
# y : trivariate variables
# r : indicator corresponding to missingness in y

set.seed(1345) 
n=100 
rho=0.5 
e1=rnorm(n,0,1) 
e2=rnorm(n,0,1) 
e3=rgamma(n,1,1) 
e4=rnorm(n,0,sd=sqrt(3/2))

y1=1+e1 
y2=2+rho*e1+sqrt(1-rho^2)*e2 
y3=y1+e3 
y4=-1+0.5*y3+e4

r1=rbinom(n,1,prob=0.6) 
r2=rbinom(n,1,prob=0.7) 
r3=rbinom(n,1,prob=0.8) 
r4=rbinom(n,1,prob=0.9)

y1[r1==0]=NA 
y2[r2==0]=NA 
y3[r3==0]=NA 
y4[r4==0]=NA

#==================================
#Chapter 3.2 script
#==================================
daty=cbind(y1,y2,y3,y4) 
summary(daty)

cdaty=FHDI_CellMake(daty,k=3) 
names(cdaty)
head(cdaty$data)

head(cdaty$cell)
apply(cdaty$cell,2,table)
cdaty$cell.resp
head(cdaty$cell.non.resp)

#==================================
#Chapter 3.3 Example
#==================================
 datz=cdaty$cell
 jcp=FHDI_CellProb(datz)
 jcp$cellpr
 sum(jcp$cellpr)
#==================================
#Chapter 3.4 Example
#==================================
FEFI=FHDI_Driver(daty,s_op_imputation="FEFI",i_op_variance=1,k=3)
names(FEFI)
FEFI$fimp.data[1:20,]

daty[1,] 
head(FEFI$simp.data)

FEFI$imp.mean

dim(FEFI$rep.weight)
FEFI$rep.weight[1:13,1:6]

FHDI=FHDI_Driver(daty,s_op_imputation="FHDI",M=5,i_op_variance=1,k=3)
FHDI$fimp.data[1:14,]

FHDI$imp.mean

FEFI=FHDI_Driver(daty,datz,s_op_imputation="FEFI",i_op_variance=1,k=3)
#==================================
#Chapter 3.5 Example
#==================================
reg.naive=lm(y1~y2,data=as.data.frame(daty))
reg.naive$coeff
summary(reg.naive)$coeff[,2]

i.daty=as.data.frame(FEFI$fimp.data)
reg.fefi=lm(y1~y2,data=i.daty,weights=FWT)
reg.fefi$coeff  

i.daty2=as.data.frame(FHDI$fimp.data)
reg.fhdi=lm(y1~y2,data=i.daty2,weights=FWT)
reg.fhdi$coeff 

reg.fefi.coef=reg.fefi$coeff
reg.est=t(apply(FEFI[[4]],2,function(s) lm(y1~y2,data=i.daty,weights=s)$coeff))
reg.fefi.rep=reg.est-matrix(reg.fefi.coef,n,2,byrow=T)
sqrt(apply(reg.fefi.rep^2,2,sum)*(n-1)/n) 
summary(reg.fefi)$coeff[,2] 

reg.fhdi.coef=reg.fhdi$coeff
reg.est2=t(apply(FHDI[[4]],2,function(s) lm(y1~y2,data=i.daty2,weights=s)$coeff))
reg.fhdi.rep=reg.est2-matrix(reg.fhdi.coef,n,2,byrow=T)
sqrt(apply(reg.fhdi.rep^2,2,sum)*(n-1)/n) 
summary(reg.fhdi)$coeff[,2] 

