# EOQ model under cooperation
library("Inventorymodel")
EOQcoo(n=3,a=600,d=c(500,300,400),h=c(9.6,11,10))

# EPQ model under cooperation
library("Inventorymodel")
EPQcoo(n=3,a=600,d=c(500,300,400),h=c(9.6,11,10),r=rep(600,3),b=c(100,150,200))

# SOC rule
library("Inventorymodel")
SOC(n=3,a=600,d=c(500,300,400),h=c(9.6,11,10),model="EOQ")

# Inventory systems
library("Inventorymodel")
STIcoo(n=3,a=200,av=c(300,300,900),d=c(90,80,20),h=c(0.06,0.06,0.1))
# Line rule
library("Inventorymodel")
linerule(n=3,a=200,av=c(300,300,900),d=c(90,80,20),h=c(0.06,0.06,0.1))

# Fixed order cost model (MFOC)
library("Inventorymodel")
mfoc(n=5,a=200,d=c(0.4,1.4,1.2,1.3,1.2),K=c(4,10,8,8,6),cooperation=0)
# Shapley value in MFOC
library("Inventorymodel")
shapley_mfoc(n=5,a=200,d=c(0.4,1.4,1.2,1.3,1.2),K=c(4,10,8,8,6))

# Model with transportation costs
library("Inventorymodel")
mct(n=3,a=400,av=c(300,500,200),d=c(2,2,5),K=c(9,8,7),cooperation=1)
# Two-lines rules
library("Inventorymodel")
twolines(n=3,a=400,av=c(300,500,200),d=c(2,2,5),K=c(9,8,7))

# Model with no holding costs and with transportation costs
library("Inventorymodel")
mwhcct(n=3,a=10,av=c(0,10,10,10,20,20,20,30),d=c(1,0.95,0.9),K=c(1,1,1),cooperation=1,
allocation = 1)

# Model with no holding costs and shortages
library("Inventorymodel")
mwhc(n=4,a=180,b=c(15,15,10,12),d=c(0.45,0.95,1.05,1.2),K=c(5,7.5,8,9),cooperation=0,
allocation=0)

# Model with no holding costs and two different costs
library("Inventorymodel")
mwhc2c(n=3,a=1,b=c(10,10,10),d=c(30,45,46),K=c(30,45,46),c1=3.5,c2=3,cooperation=0,
allocation=0)



