library(lba)
data(pregnancy)
bmi <- pregnancy[5:7,]

set.seed(1)
bmilba <- lba(bmi, 
              K = 2, 
              method = "mle", 
              what = 'outer', 
              trace.lba = FALSE)

goodnessfit(bmilba)

par(mfrow=c(1,2))
plotcorr(bmilba, 
         with.ml = 'mix', 
         col.budget = 'gray20')
plotcorr(bmilba, 
         with.ml = 'lat', 
         col.budget = 'gray20', 
         args.legend = list(ncol = 3))

mcd <- pregnancy[8:16,]

set.seed(1)
mcdlba  <- lba(mcd, 
               K = 2, 
               method = 'ls', 
               what = 'outer', 
               trace.lba = FALSE)

set.seed(1)
mcdlba1 <- lba(mcd, 
               K = 3, 
               method = 'ls', 
               what = 'outer', 
               trace.lba = FALSE)

set.seed(1)
mcdlba2 <- lba(mcd, 
               K = 4, 
               method = 'ls', 
               what = 'outer', 
               trace.lba = FALSE)              

summary(goodnessfit(mcdlba))
summary(goodnessfit(mcdlba1))
summary(goodnessfit(mcdlba2))

par(mfrow = c(1,2))
plotcorr(mcdlba1,
         xlim = c(-2,2), 
         ylim = c(-2,4), 
         col.budget = 'gray20',
         col.points = 4,
         args.legend = list(ncol = 3))
plotcorr(mcdlba1, 
         with.ml = 'lat', 
         xlim = c(-2,2),
         ylim = c(-2.5,3), 
         col.budget = 'gray20',
         col.points = 4,
         args.legend = list(ncol = 3))

mrd2 <- pregnancy[1:4,]
rownames(mrd2) <- c("Hispanic,foreign-born", 
                    "Hispanic, us-born",    
                    "White, non-hispanic", 
                    "Black, non-hispanic") 

set.seed(1)                    
mrd2lbaa <- lba(mrd2, 
                K = 2,  
                method = "mle", 
                what = 'outer', 
                trace.lba = FALSE)  

par(mfrow = c(1,2))
plotcorr(mrd2lbaa, 
         pch.points = 20,
         xlim = c(-3,2.5),
         labels.points = rownames(mrd2lbaa$Aoi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))
plotcorr(mrd2lbaa, 
         with.ml = 'lat',
         pch.points = 20,
         labels.points = rownames(mrd2lbaa$Boi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))

set.seed(4)         
mrd2lba <- lba(mrd2, 
               K = 3, 
               method = "mle", 
               what = 'outer', 
               trace.lba = FALSE)

par(mfrow = c(1,2))
plotcorr(mrd2lba, 
         with.ml = 'mix',
         xlim = c(-4.0, 3.5),
         ylim = c(-1.5, 2),
         pch.points = 20,
         col.points = 4,
         pos.points = c(3,2,4,3),
         labels.points = rownames(mrd2lba$Aoi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))
plotcorr(mrd2lba, 
         with.ml = 'lat',
         xlim = c(-2,2),
         ylim = c(-1.5,2.5),
         pch.points = 20,
         col.points = 4,
         pos.points = c(1,3,3,3,3),
         labels.points = rownames(mrd2lba$Boi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))     

data(postmater)
new_post <- as.matrix(postmater[,-1])
row.names(new_post) <- postmater[,1]

set.seed(1)
ex4 <- lba(new_post, 
           method = "mle", 
           what = 'outer', 
           K = 4, 
           tolG = 1e-5, 
           itmax.unide = 1e4,
           trace.lba = FALSE)

par(mfrow = c(1,2))                           
plotcorr(ex4, 
         main = "Mixing Parameters",
         ylim = c(-1.5,2.5),
         zlim = c(-3,3),
         pch.points = 20,
         col.points = 4,
         labels.points = rownames(ex4$Aoi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))        
plotcorr(ex4, 
         with.ml = "lat",
         main = "Latent Components",
         pch.points = 20,
         col.points = 4,
         labels.points = rownames(ex4$Boi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))  

tex4 <- ex4
class(tex4) <- c("lba.2d", 
                 "lba.mle", 
                 "lba.matrix", 
                 "lba")

par(mfrow = c(1,2))                           
plotcorr(tex4,
         main = "Mixing Parameters",
         xlim = c(-2,2),
         ylim = c(-1.5,4),
         pch.points = 20,
         col.points = 4,
         labels.points = rownames(tex4$Aoi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))         
plotcorr(tex4,
         with.ml = "lat",
         main = "Latent Components",
         xlim = c(-1.5,2.5),
         ylim = c(-2,2.5),
         pch.points = 20,
         col.points = 4,
         labels.points = rownames(tex4$Boi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))

set.seed(1)         
ex3 <- lba(new_post, 
           method = "mle", 
           what = 'outer', 
           K = 3, 
           tolG = 1e-5,
           itmax.unide = 1e4,
           trace.lba = FALSE)

par(mfrow = c(1,2))
plotcorr(ex3, 
         xlim = c(-2.5,2), 
         ylim = c(-2,2),
         main = "Mixing Parameters",
         pch.points = 20,
         col.points = 4,
         labels.points = rownames(ex3$Aoi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))
plotcorr(ex3, 
         with.ml = "lat",
         main = "Latent Components",
         xlim = c(-2,2.5),
         ylim = c(-1.5,2.5),
         pch.points = 20,
         col.points = 4,
         labels.points = rownames(ex3$Boi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))   

set.seed(1)         
ex2 <- lba(new_post, 
           method = "mle", 
           what = 'outer', 
           tolG = 1e-5, 
           itmax.unide = 1e4, 
           K = 2, 
           trace.lba = FALSE)

plotcorr(ex2,
         pch.points = 20,
         labels.points = rownames(ex2$Aoi),
         col.budget = 'gray20',
         args.legend = list(plot = FALSE))       

