# Reproduction script
# All scripts were run on a multi-core machine using parallel::mclapply().
# Code for the "iris data" example is contained in the paper and is also
# included in the sub-directory example-iris.

# Each sub-directory contains:
# 1) A script to run a simulation and output data to the "out" directory
# 2) A script to produce the figures or tables to the "fig" directory

# Benchmarking simulation - support size equals sample size
setwd("R/bench-gldrm/bench-gldrm-v5")
source("bench-gldrm.R")
source("fig.R")
setwd("../../..")

# Benchmarking simulation - support size fixed at 25
setwd("R/bench-gldrm-sptfixed/bench-gldrm-sptfixed-v2")
source("bench-gldrm-sptfixed.R")
source("fig.R")
setwd("../../..")

# Four simulations to check consistency and inference of estimators
setwd("R/check-consistency/check-consistency-v9")
source("check-consistency.R")
source("fig.R")
setwd("../../..")

# Compare Wald/score/LRT inference
setwd("R/check-consistency-score-lrt")
source("check-consistency-score-lrt.R")
source("fig.R")
setwd("../..")

# Probability inverse transform plots on simulated data
setwd("R/pit")
source("pit.R")
setwd("../..")
