
install.packages("Rcpp")
install.packages("RealVAMS")
library(RealVAMS)


data(example.outcome.data)
data(example.score.data)


res=RealVAMS(example.score.data, example.outcome.data, persistence = "CP",school.effects = FALSE,
             REML = TRUE, score.fixed.effects = formula(~as.factor(year)+cont_var),
             outcome.fixed.effects = formula(~1), max.iter.EM = 10,
             outcome.family = binomial(link = "probit"),
             tol1 = 1e-07, max.PQL.it = 30, pconv = .Machine$double.eps*1e9, var.parm.hessian = TRUE,
             verbose = TRUE)

#Extraction of output for discusion
example.outcome.data[1:5,]
example.score.data[1:5,]
res$parameters
res$teach.effects[1:4,]
res$teach.cov
res$R_i



#Syntax to create plot 

teacheffects1<-res$teach.effects[seq(1,nrow(res$teach.effects),2),]
teacheffects2= res$teach.effects[seq(2,nrow(res$teach.effects),2),]
par(mfrow=c(1,3))
plot(teacheffects1$EBLUP[1:25], teacheffects2$EBLUP[1:25], main='Year 1: Teacher Effect Estimates', 
     xlab='Estimated Teacher Effect- \n Continous Response', ylim=c(-1.5, 1.5), xlim=c(-4, 4),
     ylab=strwrap('Estimated Teacher Effect - Likelihood of Binary Response = 1 ', 37))
plot(teacheffects1$EBLUP[26:50], teacheffects2$EBLUP[26:50], main='Year 2: Teacher Effect Estimates', 
     xlab='Estimated Teacher Effect- \n Continous Response',  ylim=c(-1.5, 1.5), xlim=c(-4, 4),
     ylab=strwrap('Estimated Teacher Effect - Likelihood of Binary Response = 1 ', 37))
plot(teacheffects1$EBLUP[51:75], teacheffects2$EBLUP[51:75], main='Year 3: Teacher Effect Estimates', 
     xlab='Estimated Teacher Effect- \n Continous Response', ylim=c(-1.5, 1.5), xlim=c(-4, 4),
     ylab=strwrap('Estimated Teacher Effect - Likelihood of Binary Response = 1 ', 37))
#hightlight point for reference
points(teacheffects1$EBLUP[59], teacheffects2$EBLUP[59], col="black", pch=15, cex=1.5)



#Creates the simulated data set (example.outcome.data) 

set.seed(0)  
library(MASS)  
years=3 
teachers=25 #teacher  in  each  year   
students=25  #students  in  each  class
alpha=.5     #persistence parameter assumed 
eta.stu.j = mvrnorm(n=teachers*students,mu=c(0,0),Sigma=cbind(c(5,.2),c(.2,.1)))
eta.stu=eta.stu.j[,1] 
eta.stu.r<- eta.stu.j[,2] 
z1<-rep(1:teachers,each=students) 
z2<-sample(rep(1:teachers,each=students))
z3<-sample(rep(1:teachers,each=students)) 
cont_var1<-rnorm(students*teachers,0,.5) 
cont_var2<-rnorm(students*teachers,0,.5) 
cont_var3<-rnorm(students*teachers,0,.5) 
gam <- mvrnorm(n=teachers*years,mu=c(0,0),Sigma=cbind(c(5,.6),c(.6,.6)))
eps1<- rnorm(students*teachers,0,sqrt(5)) 
eps2<- rnorm(students*teachers,0,sqrt(5)) 
eps3<- rnorm(students*teachers,0,sqrt(5))
gam1<-gam[seq(1,teachers),1] 
gam2<-gam[seq((teachers+1),(2*teachers)),1] 
gam3<-gam[seq((2*teachers+1),(3*teachers)),1]
gam1.r<-gam[seq(1,teachers),2] 
gam2.r<-gam[seq((teachers+1),(2*teachers)),2] 
gam3.r<-gam[seq((2*teachers+1),(3*teachers)),2]
y1<-50+ eta.stu+gam1[z1]+cont_var1+eps1 
y2<-eta.stu+gam1[z1]*alpha+gam2[z2]+cont_var2+eps2
y3<-100+eta.stu+gam1[z1]*alpha+gam2[z2]*alpha+gam3[z3]+cont_var3+eps3 
r1<-rbinom(students*teachers,1,pnorm(.1+eta.stu.r+gam1.r[z1]+gam2.r[z2]+gam3.r[z3]))
student<-1:(students*teachers) 
teacher<-c(z1,z2,z3) 
cont_var<-c(cont_var1,cont_var2,cont_var3) 
year<-c(rep(1:3,each=students*teachers)) 
y<-c(y1,y2,y3) 
vam_data2<-as.data.frame(cbind(student,teacher,year,y,cont_var))
vam_data2<-vam_data2[order(vam_data2$student,vam_data2$year),] 
vam_data2<-vam_data2[-6,]
vam_data2.r<-as.data.frame(cbind(student,r=r1)) 
vam_data2.r<-vam_data2.r[-1,]


#Creates the simulated data set example.score.data 

set.seed(0) 
library(MASS) #number of years: fixed at 3 
years<-3 #number of years: fixed at 3 
teachers<-25 #teacher in each year 
students<-25 #students in each class 
alpha<-.5 
eta.stu.j <- mvrnorm(n=teachers*students,mu=c(0,0),Sigma=cbind(c(5,.2),c(.2,.1)))
eta.stu<-eta.stu.j[,1] 
eta.stu.r<- eta.stu.j[,2] 
z1<-rep(1:teachers,each=students) 
z2<-sample(rep(1:teachers,each=students))
z3<-sample(rep(1:teachers,each=students)) 
cont_var1<-rnorm(students*teachers,0,.5) 
cont_var2<-rnorm(students*teachers,0,.5) 
cont_var3<-rnorm(students*teachers,0,.5) 
gam <- mvrnorm(n=teachers*years,mu=c(0,0),Sigma=cbind(c(5,.6),c(.6,.6)))
eps1<- rnorm(students*teachers,0,sqrt(5)) 
eps2<- rnorm(students*teachers,0,sqrt(5)) 
eps3<- rnorm(students*teachers,0,sqrt(5))
gam1<-gam[seq(1,teachers),1] 
gam2<-gam[seq((teachers+1),(2*teachers)),1] 
gam3<-gam[seq((2*teachers+1),(3*teachers)),1]
gam1.r<-gam[seq(1,teachers),2] 
gam2.r<-gam[seq((teachers+1),(2*teachers)),2] 
gam3.r<-gam[seq((2*teachers+1),(3*teachers)),2]
y1<-50+ eta.stu+gam1[z1]+cont_var1+eps1 
y2<-eta.stu+gam1[z1]*alpha+gam2[z2]+cont_var2+eps2
y3<-100+eta.stu+gam1[z1]*alpha+gam2[z2]*alpha+gam3[z3]+cont_var3+eps3 
r1<-rbinom(students*teachers,1,pnorm(.1+eta.stu.r+gam1.r[z1]+gam2.r[z2]+gam3.r[z3]))
student<-1:(students*teachers) 
teacher<-c(z1,z2,z3) 
cont_var<-c(cont_var1,cont_var2,cont_var3) 
year<-c(rep(1:3,each=students*teachers)) 
y<-c(y1,y2,y3) 
vam_data2<-as.data.frame(cbind(student,teacher,year,y,cont_var))
vam_data2<-vam_data2[order(vam_data2$student,vam_data2$year),] 
vam_data2<-vam_data2[-6,]





