
rm(list = ls())

install.packages("devtools")

library(devtools)

install_github("charlottedion/mixedsde")

#-----------------------------------------------
#-- EXAMPLE 1:  CIR one multiplicative random effect 
#Xj(t)=(fixed -phij(t)Xj(t))dt+ sigma sqrt(Xj(t))dWj(t)

# Illustration of the nonparametric strategy
#-----------------------------------------------

model1 = "CIR"
random1 <- 2
M1 <- 200     
T1 <- 50   
N1 <- 1000  
sigma1 <- 0.1  
X01 <- 1
delta1 <- T1/N1
times1 <- seq(0, T1, by = delta1)
#-- fixed
fixed1 <- 1
#-- Gamma density 
density.phi1 <- "gamma"
param1 <- c(1.8, 0.8)

#- simulation
set.seed(1394)
simu1 <- mixedsde.sim(M = M1 , T=T1 ,N = N1,model = model1, random = random1, fixed = fixed1, 
                     density.phi = density.phi1, param = param1, sigma = sigma1, X0 = X01, op.plot=0)
X1 <- simu1$X
phi1 <- simu1$phi
times1 <-simu1$times
#X1[1,1:10]
#- nonparametric estimation
estim.method1 <- 'nonparam'
estim_nonparam <- mixedsde.fit(times = times1, X = X1, model = model1, random = random1, fixed = fixed1,  
                               estim.method = estim.method1) 
outputsNP <- out(estim_nonparam)

summary(estim_nonparam)

#------- Figure 1

pdf('plot_NP_ex1CIRT50.pdf')
plot(estim_nonparam)
dev.off()

#------- Figure 2
#- Left: Comparison between the true f and the estimated density
gridf1 <- outputsNP$gridf
f1 <- dgamma(gridf1, shape = param1[1], scale = param1[2])

fhat_nonparam <- outputsNP$estimf

pdf('estimdensityandphi_NP_ex1CIRT50.pdf')
op <- par(mfrow = c(1, 2), mar = c(2, 2, 1.5, 1.5), mgp = c(1.5, 0.5, 0), oma = c(0, 0, 0, 0), 
          cex.main = 0.8, cex.lab = 0.7, cex.axis = 0.7)
plot(gridf1, f1, type = 'l', lwd = 2, xlab = '', ylab = '')
lines(gridf1, fhat_nonparam, col = 'red', lwd = 2, lty = 2)

#- Right: Comparison between phi_j and the estimators 
phihat1 <- outputsNP$estimphi

plot(phi1, phihat1, xlim = c(0, max(phihat1)*1.2), ylim = c(0, max(phihat1)*1.2), 
     ylab = '', xlab ='', type = "p", pch = 18)
abline(0, 1)
dev.off()

#------- Figure 5 top plots

choice1 <- 37

png('valid1effect_ex1CIRT50.png')
validationCIR <- valid(estim_nonparam, numj = choice1)
dev.off()



rm(list = ls())
#-----------------------------------------------
#-- EXAMPLE 2:  OU one additif random effect 
#dXj(t)=(phij(t)-fixed Xj(t))dt+ sigma dWj(t)

# Illustration of the two parametric strategies
#-----------------------------------------------


model2 = "OU"
X02 <- 0
random2 <- 1
sigma2 <- 0.1 ;
M2 <- 50 ; T2 <- 1; N2 <- 500
times2 <- seq(0, T, length = N2 + 1)
#- fixed
fixed2 <- 5;
#- Gaussian density
density.phi2 <- "normal" ; param2 <- c(3, 0.5);

#- simulation
set.seed(1122)
simu2 <- mixedsde.sim(M = M2 , T=T2 ,N = N2,model = model2, random = random2, fixed = fixed2, 
                      density.phi = density.phi2, param = param2, sigma = sigma2, X0 = X02, op.plot=0)
X2 <- simu2$X
phi2 <- simu2$phi
times2 <-simu2$times


#- parametric estimation
estim.method2<-'paramML'
estim_param <- mixedsde.fit(times = times2, X = X2, model = model2, random = random2, estim.fix = 1, 
                            estim.method = estim.method2)
outputsP <- out(estim_param)

summary(estim_param)

#------- Figure 3

pdf('plot_P_ex2OUT1.pdf')
plot(estim_param)
dev.off()

#------- Figure 4
pdf('estimdensityandphi_P_ex2OUT1.pdf')
op <- par(mfrow = c(1, 2), mar = c(2, 2, 1.5, 1.5), mgp = c(1.5, 0.5, 0), oma = c(0, 0, 0, 0), 
          cex.main = 0.8, cex.lab = 0.7, cex.axis = 0.7)

#- Left: Comparison between the true density f and its estimator

gridf2 <- outputsP$gridf
f2 <- dnorm(gridf2, param2[1], param2[2])     
fhat_param <- outputsP$estimf   

plot(gridf2, f2, type = 'l', lwd = 2, xlab = '', ylab = '', ylim= c(0, 0.9)) 
lines(gridf2, fhat_param, col = 'red', lty = 2, lwd = 2)  

#- Right: Comparison between phi_j and the estimators 

phihat2 <- outputsP$estimphi  
plot(phi2, phihat2, type = "p", pch = 18, xlab = '', ylab = '', xlim = c(0, max(phihat2)*1.2), ylim = c(0, max(phihat2)*1.2))
abline(0, 1)
dev.off()

#------- Figure 5 bottom plots

choice2 <- 1
png('valid1effect_ex2OUT1.png')
validationOU <- valid(estim_param, numj = choice2)
dev.off()

#------- Figure 6

pdf('plot_pred1effect_P_ex2OUT1.pdf')
predOU <- pred(estim_param)
dev.off()


#################################### Bayesian approach


prior2 <- list( m = c(param2[1],  fixed2), v = c(param2[1], fixed2),
                    alpha.omega = 11, beta.omega = param2[2] ^ 2 * 10, alpha.sigma = 10,
                    beta.sigma = sigma2 ^ 2 * 9)
estim.method <- 'paramBayes'
estim_bayes <- mixedsde.fit(times = times2, X = X2, model = 'OU',
                     random = random2, estim.method = estim.method, prior = prior2, nMCMC = 10000) 
outputsBayes <- out(estim_bayes)

#------- Figure 7 

png('Bayes_plot_ex2.png')
plot(estim_bayes)
dev.off()

#- 
print(estim_bayes)

#------- Figure 8
pdf('Bayes_pred_ex2.pdf')
pred.result <- pred(estim_bayes)
dev.off()


#-----------------------------------------------
#--NEURONAL DATA 
#-----------------------------------------------

model <- "OU"
random <- c(1,2)
M <- 240     
T <- 0.3     
delta <- 0.00015  
N <- T/delta  

data(neuronal.data)
X <- neuronal.data[[1]]
times <- neuronal.data[[2]]

#------ Figure 9
png('ISIdata.png')
op <- par(mfrow = c(1, 1), mar = c(2, 2, 1.5, 1.5), mgp = c(1.5, 0.5, 0), oma = c(0, 0, 0, 0), 
          cex.main = 0.8, cex.lab = 0.7, cex.axis = 0.7)

plot(times, X[1, ], type ='l', ylim=c(0,0.016),xlim=c(0,0.30), xlab='', ylab='')
for (i in 1:M){
  lines(times, X[i, ], col=i)
}
dev.off()

#- nonparametric estimation
estim <- mixedsde.fit(times = times, X = X, model = 'OU', random = c(1,2),  estim.method='nonparam') 
estimCIR <- mixedsde.fit(times = times, X = X, model = 'CIR', random = c(1,2),  estim.method='nonparam') 

#- parametric estimation   
estim_param <- mixedsde.fit(times = times, X = X, model = 'OU', random=  c(1,2), estim.method = 'paramML')
estim_paramCIR <- mixedsde.fit(times = times, X = X, model = 'CIR', random = c(1,2),  estim.method='paramML') 

outputsNP <-  out(estim)
outputsP <- out(estim_param)

outputsNPCIR <-  out(estimCIR)
outputsPCIR <- out(estim_paramCIR)
#------ Table 2

reff <- matrix(round(c(kurtosis(estim_param@estimphi[1, ]), kurtosis(estim_paramCIR@estimphi[1, ]),skewness(estim_param@estimphi[1, ]),skewness(estim_paramCIR@estimphi[1, ]), 
                       kurtosis(estim_param@estimphi[2, ]), kurtosis(estim_paramCIR@estimphi[2, ]), skewness(estim_param@estimphi[1, ]),skewness(estim_paramCIR@estimphi[1, ])), 2), 
               4, 2, byrow = TRUE)
rownames(reff) <- c("Aj1 Kurtosis", "   Skewness", "Aj2 Kurtosis", "   Skewness")
colnames(reff) <- c("OU", "CIR")
print(reff, quote = FALSE, right = TRUE)

library("knitr")
kable(reff, "latex")


#------ Figure 10: case random=c(1,2)


fhat <- outputsNP$estimf
fhat_param <- outputsP$estimf 
fhatCIR <- outputsNPCIR$estimf
fhat_paramCIR <- outputsPCIR$estimf

gridf <- outputsNP$gridf
gridfCIR <- outputsNPCIR$gridf
gridf1 <- gridf[1,]; gridf2 <- gridf[2,]
gridf1CIR <- gridfCIR[1,]; gridf2CIR <- gridfCIR[2,]
marg1 <- ((max(gridf2)-min(gridf2))/length(gridf2))*apply(fhat,1,sum) #with cutoff
marg2 <- ((max(gridf1)-min(gridf1))/length(gridf1))*apply(fhat,2,sum)
marg1_param <- ((max(gridf2)-min(gridf2))/length(gridf2))*apply(fhat_param,1,sum) 
marg2_param <- ((max(gridf1)-min(gridf1))/length(gridf1))*apply(fhat_param,2,sum)

marg1CIR <- ((max(gridf2CIR)-min(gridf2CIR))/length(gridf2CIR))*apply(fhatCIR,1,sum) #with cutoff
marg2CIR <- ((max(gridf1CIR)-min(gridf1CIR))/length(gridf1CIR))*apply(fhatCIR,2,sum)
marg1_paramCIR <- ((max(gridf2CIR)-min(gridf2CIR))/length(gridf2CIR))*apply(fhat_paramCIR,1,sum) 
marg2_paramCIR <- ((max(gridf1CIR)-min(gridf1CIR))/length(gridf1CIR))*apply(fhat_paramCIR,2,sum)


pdf('reel_margin_T03_random12.pdf')
op <- par(mfrow = c(1, 2), mar = c(2, 2, 1.5, 1.5), mgp = c(1.5, 0.5, 0), oma = c(0, 0, 0, 0), 
          cex.main = 0.8, cex.lab = 0.7, cex.axis = 0.7)


plot(gridf1,marg1,type='l', col='blue', xlab='', ylab='', ylim= c(0,8))
lines(gridf1,marg1_param, lwd=2, col='blue', lty=2)
lines(gridf1CIR,marg1CIR, lwd=2, col='green')
lines(gridf1CIR,marg1_paramCIR, lwd=2, col='green', lty=2)

plot(gridf2,marg2,type='l', col='blue', xlab='', ylab='', ylim= c(0,0.4))
lines(gridf2,marg2_param, lwd=2, col='blue', lty=2)
lines(gridf2CIR,marg2CIR, lwd=2, col='green')
lines(gridf2CIR,marg2_paramCIR, lwd=2, col='green', lty=2)
dev.off()

#--------Figure 11 case random = 1

#- parametric estimation
estim_param_random1 <- mixedsde.fit(times = times, X = X, model = 'OU', random= 1, estim.fix= 1,  estim.method= 'paramML')
outputsP_random1 <- out(estim_param_random1)
fhat_param_random1 <- outputsP_random1$estimf

#- nonparametric estimation

fixed <- outputsP_random1$estim.fixed 
estim_random1 <- mixedsde.fit(times = times, X = X, model = model, random = 1, fixed = fixed, estim.method = "nonparam")
outputsNP_random1 <- out(estim_random1)
fhat_random1 <- outputsNP_random1$estimf  


phihat_random1 <- outputsNP_random1$estimphi  
gridf_random1 <- outputsNP_random1$gridf 

pdf('reel_OU_random1_estimf_hist.pdf')
op <- par(mfrow = c(1, 1), mar = c(2, 2, 1.5, 1.5), mgp = c(1.5, 0.5, 0), oma = c(0, 0, 0, 0), 
          cex.main = 0.8, cex.lab = 0.7, cex.axis = 0.7)

hist( phihat_random1, freq=FALSE, ylim = c(0,8), xlim = c(0, max(phihat_random1) * 1.2), 
      breaks = seq(min(phihat_random1)*0.8, max(phihat_random1)*1.2, length = 12), main='', xlab='', ylab='')
lines(gridf_random1,  fhat_param_random1, type = 'l', lty = 2, lwd = 2, col = 'blue')
lines(gridf_random1, fhat_random1, type = 'l', col = 'blue', lwd = 2)

dev.off()

#--------Figure 12 case random = 1, validation of trajectory 141

png('reel_validind_random1_OU_141.png')
predOUrandom1 <- valid (estim_random1, numj = 141)
dev.off()

###################################################

# Table 3 Parametric estimation with the fixed effect also estimated

estim_param12 <- mixedsde.fit(times = times, X = X, model = 'OU', random = c(1,2), estim.method = 'paramML')
estim_param1 <- mixedsde.fit(times = times, X = X, model = 'OU', random = 1, estim.fix = 1, estim.method = 'paramML')
estim_param2 <- mixedsde.fit(times = times, X = X, model = 'OU', random = 2, estim.fix = 1, estim.method = 'paramML')

reff <- matrix(round(c(estim_param12@mu[1],estim_param12@omega[1], estim_param12@mu[2], estim_param12@omega[2], estim_param12@bic, estim_param12@aic,
                         estim_param2@estim.fixed,0, estim_param2@mu, estim_param2@omega,estim_param2@bic, estim_param2@aic,
                          estim_param1@mu,estim_param1@omega, estim_param1@estim.fixed,0,estim_param1@bic, estim_param1@aic),2),  3, 6, byrow = TRUE)
rownames(reff) <- c("Random c(1,2)", "Random 2", "Random 1")
colnames(reff) <- c("mu1", "omega1","mu2", "omega2", "BIC", "AIC") 
#print(reff, quote = FALSE, right = TRUE)

library("knitr")
kable(reff, "latex") 


# Table 4

estim_param1picch2008 <- mixedsde.fit(times = times, X = X, model = 'OU', random = 1, fixed = 25.64 , estim.method = 'paramML')
estim_param1picch2010 <- mixedsde.fit(times = times, X = X, model = 'OU', random = 1, fixed = 47, estim.method = 'paramML')
estim_param1new <- mixedsde.fit(times = times, X = X, model = 'OU', random = 1, fixed = estim_param1@estim.fixed, estim.method = 'paramML')

reff <- matrix(round(c(estim_param1picch2008@mu,estim_param1picch2008@omega, estim_param1picch2008@fixed ,estim_param1picch2008@bic, estim_param1picch2008@aic,
                       estim_param1picch2010@mu,estim_param1picch2010@omega, estim_param1picch2010@fixed ,estim_param1picch2010@bic, estim_param1picch2010@aic,
                       estim_param1new@mu,estim_param1new@omega, estim_param1new@fixed ,estim_param1new@bic, estim_param1new@aic),2),  3, 5, byrow = TRUE)
rownames(reff) <- c("beta from Picchini 2008", "beta from Picchini 2010", "Previous estimator MLE of beta")
colnames(reff) <- c("mu1", "omega1","beta", "BIC", "AIC") 
#print(reff, quote = FALSE, right = TRUE)

library("knitr")
kable(reff, "latex")
################################################### Bayesian

ind <- seq(1, 2000, by=10)

estim_Bayes <- mixedsde.fit(times[ind], X[,ind], model = "OU", random = 1, estim.method = 'paramBayes', nMCMC = 20000)


estim_Bayes2 <- mixedsde.fit(times[ind], X[,ind], model = "OU", random = 2, estim.method = 'paramBayes', nMCMC = 20000) 

estim_Bayes12 <- mixedsde.fit(times[ind], X[,ind], model = "OU", random = c(1, 2), estim.method = 'paramBayes', nMCMC = 20000) 

pred.result <- pred(estim_Bayes, cand.length = 200)

pred.result2 <- pred(estim_Bayes2, cand.length = 200)

pred.result12 <- pred(estim_Bayes12, cand.length = 200)



#--------Figure 13 case random = 1

png('chainsISIdata.png')
plot(estim_Bayes, reduced =  TRUE)
dev.off()



#--------Figure 14 comparison of random = 1, 2, and c(1, 2)

pdf('comp_predictionIntervalsISIdata.pdf')
plot2compare(pred.result, pred.result2, pred.result12)
dev.off()






