# Script tested with ipft version 0.7.2

# INSTALL PACKAGE
###################################################################################################
install.packages('ipft')
library('ipft')
###################################################################################################




# SECTION 4: DATA WRANGLING
###################################################################################################
trainRSSI <- ipfTransform(ipftrain[, 1:168], outRange = c(0.1, 1), inNoRSSI = NA, outNoRSSI = NA)
testRSSI <- ipfTransform(ipftest[, 1:168], outRange = c(0.1, 1), inNoRSSI = NA, outNoRSSI = NA)
###################################################################################################




# SECTION 5.1: THE IPFKNN FUNCTION
###################################################################################################
tr_fingerprints <- trainRSSI[, 1:168]
tr_positions    <- ipftrain[, 169:170]
knnModel        <- ipfKnn(tr_fingerprints, tr_positions, k = 7, method = "euclidean")
ts_fingerprints <- testRSSI[, 1:168]
ts_positions    <- ipftest[, 169:170]
knnEstimation   <- ipfEstimate(knnModel, ts_fingerprints, ts_positions)
mean(knnEstimation$errors)
# 3.302739
head(knnEstimation$neighbors)
#      [,1] [,2] [,3] [,4] [,5] [,6] [,7]
# [1,]   71  176  126  125  127  771  130
# [2,]   71  176  126  125  127  771  130
# [3,]  465  914  915  913  217   77  218
# [4,]  465  914  915  176  913  461  217
# [5,]  176  126  125  771  130  127  914
# [6,]   77  914  915  217  176  465  218


#----------------#


library(Rcpp)
cppFunction('
  NumericMatrix myD(NumericMatrix train, NumericMatrix test, double F = 2.0) {
    NumericMatrix distanceMatrix(test.nrow(), train.nrow());
    double d = 0, pv = 0, rssi1 = 0, rssi2 = 0;
    for (int itrain = 0; itrain < train.nrow(); itrain++) {
      for (int itest = 0; itest < test.nrow(); itest++) {
        d = 0;
        for (int i = 0; i < train.ncol(); i++) {
          rssi1 = R_IsNA(train(itrain, i))? 0 : train(itrain, i);
          rssi2 = R_IsNA(test(itest, i))? 0 : test(itest, i);
          pv = (rssi1 != 0 && rssi2 != 0)? 1 : F;
          d = d + std::abs(rssi1 - rssi2) * pv;
        }
        distanceMatrix(itest, itrain) = d;
      }
    }
    return distanceMatrix;
  }'
)
customModel      <- ipfKnn(tr_fingerprints, tr_positions, k = 1, FUN = myD, F = 0.25)
customEstimation <- ipfEstimate(customModel, ts_fingerprints, ts_positions)
head(customEstimation$neighbors)
#      [,1]
# [1,]  773
# [2,]  773
# [3,]  773
# [4,]  773
# [5,]  130
# [6,]  130
head(customEstimation$errors)
# [1] 5.708275 5.708275 5.708275 5.708275 3.380000 3.380000
mean(customEstimation$errors)
# [1] 3.297342

#----------------#

# Figure 1
ipfPlotEcdf(customEstimation) # + theme_bw() + theme(panel.grid.major = element_blank())

# Figure 2
ipfPlotPdf(customEstimation) # + theme_bw() + theme(panel.grid.major = element_blank())

###################################################################################################




# SECTION 5.2: THE IPFPROBABILISTIC FUNCTION
###################################################################################################
probModel <- ipfProbabilistic(tr_fingerprints, tr_positions, k = 7, delta = 10)
head(probModel$data$positions)
#      X     Y
# 1 -0.6 24.42
# 2 -0.6 27.42
# 3  0.0  0.00
# 4  0.4  0.00
# 5  0.4  3.38
# 6  0.4  6.81

probEstimation <- ipfEstimate(probModel, ts_fingerprints, ts_positions)
mean(probEstimation$errors)
# [1] 6.069336


#----------------#


probModel       <- ipfProbabilistic(tr_fingerprints, tr_positions, k = 9, delta = 10, FUN = max, na.rm = TRUE)
probEstimation  <- ipfEstimate(probModel, ts_fingerprints, ts_positions)
mean(probEstimation$errors)
# [1] 8.652321

###################################################################################################


# SECTION 5.3: THE IPFPROXIMITY FUNCTION
###################################################################################################
proxModel      <- ipfProximity(ipfpwap, alpha = 4, rssirange = c(-100, 0), norssi = NA, wapPow1 = -32)
proxEstimation <- ipfEstimate(proxModel, ipftest[, 1:168], ipftest[, 169:170])
mean(proxEstimation$errors)
# 8.0444

###################################################################################################




# SECTION 6: BEACON POSITION ESTIMATION
###################################################################################################
bc_positions   <- ipfEstimateBeaconPositions(ts_fingerprints, ts_positions, method = 'wcentroid')
proxModel      <- ipfProximity(bc_positions, rssirange = c(0.1, 1), norssi = NA)
proxEstimation <- ipfEstimate(proxModel, ts_fingerprints[1:6,], ts_positions[1:6,])
proxEstimation$location
#         V1       V2
# 1 1.686950 12.02117
# 2 1.686950 12.02117
# 3 1.654255 10.91767
# 4 1.682121 10.96035
# 5 1.711448 10.88966
# 6 1.695007 10.09507

###################################################################################################




# SECTION 7: DATA CLUSTERING
###################################################################################################

set.seed(1)
cl_fingerprints <- ipfTransform(tr_fingerprints, inNoRSSI = NA, outNoRSSI = 0)
clusterData     <- ipfCluster(cl_fingerprints, k = 30, iter.max = 20, algorithm = "MacQueen")
head(clusterData$clusters)
# [1] 3 3 3 3 3 3

# ------------------------------ #

clusterData     <- ipfCluster(tr_fingerprints, method = 'AP')
dim(clusterData$centers)
#[1]  43 168

# ------------------------------ #

groups <- ipfGroup(ipftrain, X, Y)
head(groups)
# [1]  4  4  4  4 22 22

length(unique(groups))
# [1] 41

###################################################################################################




# SECTION 8: PLOTTING FUNCTIONS
###################################################################################################

# Figure 4
library(ggplot2)
ipfPlotLocation(ipftrain[, 169:170], plabel = TRUE, reverseAxis = TRUE) + theme_bw()

# Figure 5
library(ggplot2)
probModel <- ipfProbabilistic(ipftrain[, 1:168], ipftrain[, 169:170])
probEst   <- ipfEstimate(probModel, ipftest[, 1:168], ipftest[, 169:170])
ipfPlotEstimation(probModel, probEst, ipftest[, 169:170], observations = c(61:62, 81:82),
                  reverseAxis = TRUE, showneighbors = TRUE, showLabels = TRUE)
                + theme_bw()

###################################################################################################

