# Config

# please adapt if no CUDA available
# but then please comment out the long tests (4D and higher)
# also - blind 5D test might be considered long even with CUDA
# note that results are included saved in piliszek.RData
use.CUDA <- T

# Preliminaries

library(MDFS)

x <- madelon$data
y <- madelon$decision

GetOrderedRelevant <- function (result) {
  result$relevant.variables[order(result$p.value[result$relevant.variables])]
}

seed <- 118912 # one seed to rule them all

# Insightful tests

n.contrast <- 0
discretizations <- 1
range <- 0

d1 <- MDFS(x, y, n.contrast = n.contrast, dimensions = 1, divisions = 1,
           discretizations = discretizations, range = range, seed = seed)
d1.relevant.ordered <- GetOrderedRelevant(d1)

d2 <- MDFS(x, y, n.contrast = n.contrast, dimensions = 2, divisions = 1,
           discretizations = discretizations, range = range, seed = seed,
           use.CUDA = use.CUDA)
d2.relevant.ordered <- GetOrderedRelevant(d2)

d3 <- MDFS(x, y, n.contrast = n.contrast, dimensions = 3, divisions = 1,
           discretizations = discretizations, range = range, seed = seed,
           use.CUDA = use.CUDA)
d3.relevant.ordered <- GetOrderedRelevant(d3)

d4 <- MDFS(x, y, n.contrast = n.contrast, dimensions = 4, divisions = 1,
           discretizations = discretizations, range = range, seed = seed,
           use.CUDA = use.CUDA)
d4.relevant.ordered <- GetOrderedRelevant(d4)

d5 <- MDFS(x, y, n.contrast = n.contrast, dimensions = 5, divisions = 1,
           discretizations = discretizations, range = range, seed = seed,
           use.CUDA = use.CUDA)
d5.relevant.ordered <- GetOrderedRelevant(d5)

# Blind tests

n.contrast <- 50
discretizations <- 30
range <- NULL # autoselected

d1b <- MDFS(x, y, n.contrast = n.contrast, dimensions = 1, divisions = 1,
            discretizations = discretizations, range = range, seed = seed)
d1b.relevant.ordered <- GetOrderedRelevant(d1b)

d2b <- MDFS(x, y, n.contrast = n.contrast, dimensions = 2, divisions = 1,
            discretizations = discretizations, range = range, seed = seed,
            use.CUDA = use.CUDA)
d2b.relevant.ordered <- GetOrderedRelevant(d2b)

d3b <- MDFS(x, y, n.contrast = n.contrast, dimensions = 3, divisions = 1,
            discretizations = discretizations, range = range, seed = seed,
            use.CUDA = use.CUDA)
d3b.relevant.ordered <- GetOrderedRelevant(d3b)

d4b <- MDFS(x, y, n.contrast = n.contrast, dimensions = 4, divisions = 1,
            discretizations = discretizations, range = range, seed = seed,
            use.CUDA = use.CUDA)
d4b.relevant.ordered <- GetOrderedRelevant(d4b)

d5b <- MDFS(x, y, n.contrast = n.contrast, dimensions = 5, divisions = 1,
            discretizations = discretizations, range = range, seed = seed,
            use.CUDA = use.CUDA)
d5b.relevant.ordered <- GetOrderedRelevant(d5b)

rm(x, y, use.CUDA, seed, n.contrast, discretizations, range, GetOrderedRelevant)
save.image('piliszek.RData')

# Correlation plots

library(corrplot)

C.1d <- cor(x[, d1.relevant.ordered]) ^ 2
rownames(C.1d) <- colnames(C.1d) <- d1.relevant.ordered

C.2d <- cor(x[, d2.relevant.ordered]) ^ 2
rownames(C.2d) <- colnames(C.2d) <- d2.relevant.ordered

C.3d <- cor(x[, d3.relevant.ordered]) ^ 2
rownames(C.3d) <- colnames(C.3d) <- d3.relevant.ordered

C.5d <- cor(x[, d5.relevant.ordered]) ^ 2
rownames(C.5d) <- colnames(C.5d) <- d5.relevant.ordered

layout(matrix(c(1, 3, 2, 4), 2))
corrplot(C.1d, main = "1D", mar = c(1, 1, 2, 1))
corrplot(C.2d, main = "2D", mar = c(1, 1, 2, 1))
corrplot(C.3d, main = "3D", mar = c(1, 1, 2, 1))
corrplot(C.5d, main = "5D", mar = c(1, 1, 2, 1))

# Plot helper

grabIGBest50 <- function (dX) {
  dX$MIG.Result$IG[order(dX$MIG.Result$IG, decreasing = T)][1:50]
}

# Insightful IG plot

layout(1)
plot(grabIGBest50(d1), col = "red", ylim = c(0, 700), ylab = "Information gain")
points(d1$MIG.Result$IG[d1.relevant.ordered], col = "red", pch = 19)
points(grabIGBest50(d2), col = "violet")
points(d2$MIG.Result$IG[d2.relevant.ordered], col = "violet", pch = 19)
points(grabIGBest50(d3), col = "blue")
points(d3$MIG.Result$IG[d3.relevant.ordered], col = "blue", pch = 19)
points(grabIGBest50(d4), col = "green")
points(d4$MIG.Result$IG[d4.relevant.ordered], col = "green", pch = 19)
points(grabIGBest50(d5), col = "brown")
points(d5$MIG.Result$IG[d5.relevant.ordered], col = "brown", pch = 19)
legend(30, 700, c("relevant", "    1D", "    2D", "    3D", "    4D", "    5D",
                "irrelevant", "    1D", "    2D", "    3D", "    4D", "    5D"),
       col = c("white", "red", "violet", "blue", "green", "brown"),
       pch = c(0, 19, 19, 19, 19, 19, 0, 1, 1, 1, 1, 1), ncol = 2, bty = "n")

# Blind IG plot

layout(1)
plot(grabIGBest50(d1b), col = "red", ylim = c(0, 700), ylab = "Information gain")
points(d1b$MIG.Result$IG[d1b.relevant.ordered], col = "red", pch = 19)
points(grabIGBest50(d2b), col = "violet")
points(d2b$MIG.Result$IG[d2b.relevant.ordered], col = "violet", pch = 19)
points(grabIGBest50(d3b), col = "blue")
points(d3b$MIG.Result$IG[d3b.relevant.ordered], col = "blue", pch = 19)
points(grabIGBest50(d4b), col = "green")
points(d4b$MIG.Result$IG[d4b.relevant.ordered], col = "green", pch = 19)
points(grabIGBest50(d5b), col = "brown")
points(d5b$MIG.Result$IG[d5b.relevant.ordered], col = "brown", pch = 19)
legend(30, 700, c("relevant", "    1D", "    2D", "    3D", "    4D", "    5D",
                "irrelevant", "    1D", "    2D", "    3D", "    4D", "    5D"),
       col = c("white", "red", "violet", "blue", "green", "brown"),
       pch = c(0, 19, 19, 19, 19, 19, 0, 1, 1, 1, 1, 1), ncol = 2, bty = "n")
