# Reproductible example for the article
# Nowcasting: An R Package for predicting
# economic variables using dynamic factor models
# by Daiane Marcolino, Pedro Ferreira and Serge de Valk

devtools::install_github('nmecsys/nowcasting') # latest available version from github
install.packages("nowcasting") # version available on cran

# start of the first working example
library(nowcasting)
data(BRGDP)

vintage <- PRTDB(mts = BRGDP$base, delay = BRGDP$delay, vintage = "2015-06-01")
base <- window(vintage, start = c(2005,06), frequency = 12)
x <- Bpanel(base = base, trans = BRGDP$trans)

GDP <- base[,which(colnames(base) == "PIB")]
window(GDP, start = c(2015,1))
GDP_qtr <- month2qtr(x = GDP,reference_month = 3)
window(GDP_qtr, start = c(2015,1))

y <- diff(diff(GDP_qtr),4)

ICR1 <- ICfactors(x = x, type = 1)
ICR2 <- ICfactors(x = x, type = 2)

ICQ1 <- ICshocks(x = x, r = 2, p = 2)
ICQ1$q_star

now <- nowcast(y = y, x = x, r = 2, q = 2 , p = 2, method = "2s_agg")
summary(now$reg)

nowcast.plot(now, type = "fcst")
nowcast.plot(now, type = "eigenvalues")

level_forecast <- na.omit(now$yfcst[,3])[1] - tail(na.omit(GDP_qtr),5)[1] +
  +   tail(na.omit(GDP_qtr),5)[5] + tail(na.omit(GDP_qtr),5)[2]
level_forecast

position_q2_2015 <- which(time(BRGDP$GDP) == 2015.25)
BRGDP$GDP[position_q2_2015]

# start of the second working example
data(NYFED)
NYFED$legend$SeriesName

base <- NYFED$base
blocks <- NYFED$blocks$blocks
trans <- NYFED$legend$Transformation
frequency <- NYFED$legend$Frequency

x <- Bpanel(base = base, trans = trans, NA.replace = F, na.prop = 1)

nowEM <- nowcast(y = "GDPC1", x = x, r = 1, p = 1, method = "EM", blocks = blocks, frequency = frequency)

nowcast.plot(nowEM)

