library(MapGAM)
library(PBSmapping)
library(maptools)
# Section 2.3
data(MAdata)
data(MAmap)
summary(MAdata)
# Figure 1
# map participants, cases in red and controls in black
# pdf("MAmap.pdf")
plot(MAmap)
points(MAdata$Xcoord,MAdata$Ycoord,col=MAdata$Case+1,pch=c(1,4)[MAdata$Case+1],cex=0.5)
# dev.off()
gamgrid <- predgrid(MAdata, map=MAmap)    # requires PBSmapping package
fit1 <- modgam(Case ~ lo(Xcoord, Ycoord) + Smoking + Mercury + Selenium, 
               data=MAdata, rgrid=gamgrid, type="spatial", sp=NULL, 
               verbose = FALSE)
# which is equivalent to 
# fit1 <- modgam(data=MAdata,rgrid=gamgrid, m="adjusted", type="spatial",
#               sp=NULL, verbose=FALSE)
#
fit1
# Figure 2
# pdf("heatmap_MA.pdf")
plot(fit1,MAmap,exp = TRUE, contours="response")
# dev.off()

# Section 3.2 
# simulation

## sampling data
sim.sample.data <- function(f,N=5000){
  set.seed(269)
  u <- runif(N,-1,1)
  v <- runif(N,-1,1)
  x <- runif(N,-1,1)
  lambda <- 0.03*exp(f(u,v,x))
  eventTime <- rexp(N,lambda)
  censTime <- runif(N,0,70)
  time <- ifelse(eventTime<=censTime, eventTime, censTime)
  event <- (eventTime<=censTime)*1
  obs.data=data.frame(time=time,event=event,u=u,v=v,x=x)
  new.data = data.frame(u=rep(seq(-1,1,0.01),each=201),
                        v=rep(seq(-1,1,0.01),201))
  truth = f(new.data$u,new.data$v,0)
  list(obs=obs.data, new=new.data,truth = truth-median(truth))
}

## linear relationship only
f.linear <- function(u,v,x){
  log(0.7)*x + log(1.2)*u + log(1.5)*v
}
data.linear <- sim.sample.data(f.linear)
fit.linear <- modgam(Surv(time,event)~lo(u,v)+x,data=data.linear$obs,
              rgrid=data.linear$new,family="survival",sp=0.3)
## nonlinear relationship
f.nonlinear <- function(u,v,x){
  log(0.7)*x + log(1.2)*u + log(1.5)*v+log(0.8)*u^2+log(1.8)*u*v
}
data.nonlinear <- sim.sample.data(f.nonlinear)
fit.nonlinear <- modgam(Surv(time,event)~lo(u,v)+x,data=data.nonlinear$obs,
              rgrid=data.nonlinear$new,family="survival",sp=0.2)

# Figure 3
par(mfrow=c(2,2))
#pdf("heatmap_linear_truth.pdf",5,5)
obj.linear <- list(grid=data.linear$new,fit=data.linear$truth)
colormap(obj.linear,axes=T,arrow=F,mapmin=-0.6,mapmax=0.55,
legend.name="log hazard ratio",legend.cex=1.3,legend.add.line=0)
#dev.off()
mtext("(a) Truths for linear spatial effect",side=1,line=4)
#pdf("heatmap_linear_est.pdf",5,5)
plot(fit.linear,mapmin=-0.6,mapmax=0.55,axes=T,arrow=F,legend.cex=1.3)
mtext("(b) Estimates for linear spatial effect",side=1,line=4)
#dev.off()
#pdf("heatmap_nonlinear_truth.pdf",5,5)
obj.nonlinear <- list(grid=data.nonlinear$new,fit=data.nonlinear$truth)
colormap(obj.nonlinear,axes=T,arrow=F,mapmin=-0.9,mapmax=1.05,
legend.name="log hazard ratio",legend.cex=1.3,legend.add.line=0)
mtext("(c) Truths for nonlinear spatial effect",side=1,line=4)
#dev.off()
#pdf("heatmap_nonlinear_est.pdf",5,5)
plot(fit.nonlinear,mapmin=-0.9,mapmax=1.05,axes=T,arrow=F,legend.cex=1.3)
mtext("(d) Estimates for nonlinear spatial effect",side=1,line=4)
#dev.off()

# Figure 4
op.mai = par()$mai
op.mfrow = par()$mfrow
#pdf("comparison_simulation.pdf",width=9,height=5)
par(mfrow=c(1,2),mai=c(1.3,0.8,0.4,0.4))
#pdf("comparison_linear.pdf",5,5)
plot(data.linear$truth,fit.linear$fit,xlab="true log hazard ratio",ylab="predicted log hazard ratio")
abline(0,1,lwd=4,col="green")
mtext("(a) Linear spatial effect",side=1,line=4.5)
#dev.off()
#pdf("comparison_nonlinear.pdf",5,5)
plot(data.nonlinear$truth,fit.nonlinear$fit,xlab="true log hazard ratio",ylab="predicted log hazard ratio")
abline(0,1,lwd=4,col="green")
mtext("(b) Nonlinear spatial effect",side=1,line=4.5)
#dev.off()
par(mai=op.mai,mfrow = op.mfrow)

#example2
data(CAdata)
summary(CAdata)
data(CAmap)

# Figure 5
# pdf("CAdata.pdf")
par(mfrow=c(1,1))
plot(CAmap)
points(CAdata$X,CAdata$Y,col=CAdata$event+1,pch=c(1,4)[CAdata$event+1],cex=0.5)
# dev.off()

# Section 3.3 Example
CAgrid = predgrid(CAdata[,c("X","Y")],map=CAmap,nrow=186,ncol=179)
fit2 <- modgam(Surv(time,event)~AGE+factor(INS)+lo(X,Y),data=CAdata,
        rgrid=CAgrid, family="survival",sp=0.3, verbose =FALSE)

# which is equivalent to 
# fit2 <- modgam(data=CAdata,rgrid = CAgrid,family="survival",sp = 0.3, 
#          verbose = FALSE)

# Figure 6
#pdf("heatmap_CA.pdf")
plot(fit2,CAmap,border.gray=0.5)
#dev.off()
fit2

## Section 4.2 Example
## example3
fit3 <- modgam(Surv(time,event)~AGE+factor(INS)+lo(X,Y),data=CAdata,
        rgrid=CAgrid, sp=0.3, verbose =FALSE, se.fit=TRUE)
# Figure 7
#pdf("intervals.pdf",height=5,width=10)
plot(fit3,CAmap,mapmin=-1.61,mapmax=1.74,border.gray=0.7,contours="interval")
#dev.off()
fit3

