library(NonProbEst)

head(sampleNP)

head(population)
totals <- colSums(population)
totals

covariates <- colnames(sampleNP)[4:9]
initial_weights <- rep(1, nrow(sampleNP))
w <- calib_weights(sampleNP[, covariates], totals, initial_weights,
	N = 50000, method = "raking")

mean_estimation(sampleNP, w, "vote_gen", N = 50000)
mean_estimation(sampleNP, w, "vote_pens", N = 50000)
mean_estimation(sampleNP, w, "vote_pir", N = 50000)

sum(sampleNP$vote_gen)/nrow(sampleNP)
sum(sampleNP$vote_pens)/nrow(sampleNP)
sum(sampleNP$vote_pir)/nrow(sampleNP)

sum(sampleNP$vote_gen)/nrow(sampleNP) -
	mean_estimation(sampleNP, w, "vote_gen", N = 50000)
sum(sampleNP$vote_pens)/nrow(sampleNP) -
	mean_estimation(sampleNP, w, "vote_pens", N = 50000)
sum(sampleNP$vote_pir)/nrow(sampleNP) -
	mean_estimation(sampleNP, w, "vote_pir", N = 50000)

### Leave-One-Out Jackknife variance estimation with reweighting
estimator <- function(s){
	initial_weights <- rep(1, nrow(s))
	w <- calib_weights(s[,covariates], totals, initial_weights, N = 50000,
		method = "raking")
	return(mean_estimation(s, w, "vote_pir", N = 50000))
}
v_r <- generic_jackknife_variance(sampleNP, estimator, N = 50000)
v_r

### Leave-One-Out Jackknife variance estimation without reweighting
v_nr <- fast_jackknife_variance(sampleNP, w, estimated_vars = "vote_pir", N = 50000)
v_nr

ic_r <- confidence_interval( mean_estimation(sampleNP, w, "vote_pir", N = 50000),
	sqrt(v_r)
)
ic_r
ic_nr <- confidence_interval( mean_estimation(sampleNP, w, "vote_pir", N = 50000),
	sqrt(v_nr)
)
ic_nr

head(sampleP)

covariates <- colnames(sampleP)
pi <- propensities(sampleNP, sampleP, covariates,
	algorithm = "knn", smooth = T, tuneGrid = data.frame(k = seq(3, 11, by = 2)))
summary(pi$convenience)
summary(pi$reference)

wi <- vd_weights(convenience_propensities = pi$convenience,
	reference_propensities = pi$reference)
summary(wi)
mean_estimation(sample = sampleNP, weights = wi,
	estimated_vars = "vote_pir")
#Estimation of the 95% confidence interval
estim <- mean_estimation(sample = sampleNP, weights = wi,
	estimated_vars = "vote_pir")
std_dev <- fast_jackknife_variance(sample = sampleNP, weights = wi,
	estimated_vars = "vote_pir", N = 50000)
confidence_interval(estimation = estim, std_dev = std_dev, confidence = 0.95)

wi <- sc_weights(propensities = pi$convenience)
summary(wi)

covariates <- c("education_primaria", "education_secundaria",
	"education_terciaria", "age", "sex", "language")
mySample = sampleNP
mySample$vote_pens = factor(mySample$vote_pens, c(0, 1), c('F', 'T'))
model_based(mySample, population, covariates, "vote_pens",
	positive_label = 'T', algorithm = "glmnet", proc = c("center", "scale"))

model_based(mySample, population, covariates, "vote_pens", positive_label = 'T',
	algorithm = "glmnet", proc = c("center", "scale"), estimate_mean = TRUE)

model_calibrated(sample_data = mySample, weights = 1, full_data = population,
	covariates = covariates, estimated_var = "vote_pens", positive_label = 'T',
	algorithm = "glmnet", proc = c("center","scale"),
	estimate_mean = TRUE)
