#### Code for results on elapsed time of LOO Jackknife variance estimation for Table 1 ####
library(NonProbEst)

set.seed(1)

np <- sampleNP[sample(1:1000,100),]
p <- sampleP[sample(1:500,100),]

stamp <- Sys.time()
jackknife_variance("vote_pir",np,p,c("age","sex"),N=50000)
Sys.time() - stamp
## Time difference of 1.259339 mins

stamp <- Sys.time()
jackknife_variance("vote_pir",np,p,c("age","sex"),N=50000, algorithm = "rpart")
Sys.time() - stamp
## Time difference of 1.705681 mins

stamp <- Sys.time()
garbage <- capture.output(
  jackknife_variance("vote_pir",np,p,c("age","sex"),N=50000, algorithm = "gbm"))
Sys.time() - stamp
## Time difference of 7.562183 mins

stamp <- Sys.time()
jackknife_variance("vote_pir",np,p,c("age","sex"),N=50000, algorithm = "rf")
Sys.time() - stamp
## Time difference of 3.396228 mins

stamp <- Sys.time()
garbage <- capture.output(
  jackknife_variance("vote_pir",np,p,c("age","sex"),N=50000, algorithm = "nnet"))
Sys.time() - stamp
## Time difference of 11.99555 mins

wi <- sc_weights(propensities(np, p, c("age","sex"))$convenience)
stamp <- Sys.time()
fast_jackknife_variance(np, wi, "vote_pir", N = 50000)
Sys.time() - stamp
#Time difference of 0.004999876 secs

#### Code for examples in InfoTP section ####
library(NonProbEst)

head(sampleNP)
head(population)

totals <- colSums(population)
totals
#education_primaria education_secundaria  education_terciaria                  age                  sex             language
#25287                10546                14167              2539340                24430                45429

covariates <- colnames(sampleNP)[4:9]
initial_weights <- rep(1, nrow(sampleNP))
w <- calib_weights(sampleNP[, covariates], totals, initial_weights,
                   N = 50000, method = "raking")

mean_estimation(sampleNP, w, "vote_gen", N = 50000)
#vote_gen
#0.09824163
mean_estimation(sampleNP, w, "vote_pens", N = 50000)
#vote_pens
#0.3726149
mean_estimation(sampleNP, w, "vote_pir", N = 50000)
# vote_pir
#0.3905399

sum(sampleNP$vote_gen)/nrow(sampleNP)
#[1] 0.096
sum(sampleNP$vote_pens)/nrow(sampleNP)
#[1] 0.346
sum(sampleNP$vote_pir)/nrow(sampleNP)
#[1] 0.404
sum(sampleNP$vote_gen)/nrow(sampleNP) -
  mean_estimation(sampleNP, w, "vote_gen", N = 50000)
#vote_gen
#-0.00224163
sum(sampleNP$vote_pens)/nrow(sampleNP) -
  mean_estimation(sampleNP, w, "vote_pens", N = 50000)
#vote_pens
#-0.02661494
sum(sampleNP$vote_pir)/nrow(sampleNP) -
  mean_estimation(sampleNP, w, "vote_pir", N = 50000)
#vote_pir
#0.01346014

### Leave-One-Out Jackknife variance estimation with reweighting
estimator <- function(s){
     initial_weights <- rep(1, nrow(s))
     w <- calib_weights(s[,covariates], totals, initial_weights, N = 50000,
                       +		method = "raking")
     return(mean_estimation(s, w, "vote_pir", N = 50000))
     }
v_r <- generic_jackknife_variance(sampleNP, estimator, N = 50000)
v_r
#[1] 0.0003352199
### Leave-One-Out Jackknife variance estimation without reweighting
v_nr <- fast_jackknife_variance(sampleNP, w, estimated_vars = "vote_pir", N = 50000)
v_nr
#vote_pir
#0.0003189449

ic_r <- confidence_interval( mean_estimation(sampleNP, w, "vote_pir", N = 50000),
                               sqrt(v_r)
                             )
ic_r
#lower.vote_pir upper.vote_pir
#0.3546549      0.4264249
ic_nr <- confidence_interval( mean_estimation(sampleNP, w, "vote_pir", N = 50000),
                                sqrt(v_nr)
                              )
ic_nr
#lower.vote_pir upper.vote_pir
#0.3555368      0.4255429

#### Code for examples in InfoSP section ####

head(sampleP)

covariates <- colnames(sampleP)
pi <- propensities(sampleNP, sampleP, covariates,
                     algorithm = "knn", smooth = T, tuneGrid = data.frame(k = seq(3, 11, by = 2)))
summary(pi$convenience)
#Min. 1st Qu.  Median    Mean 3rd Qu.    Max.
#0.3079  0.6249  0.6873  0.6834  0.7584  0.9995
summary(pi$reference)
#Min. 1st Qu.  Median    Mean 3rd Qu.    Max.
#0.3079  0.5384  0.6388  0.6236  0.6998  0.9469

wi <- vd_weights(convenience_propensities = pi$convenience,
                   reference_propensities = pi$reference)
summary(wi)
#Min. 1st Qu.  Median    Mean 3rd Qu.    Max.
#1.233   1.376   1.493   1.505   1.632   2.011
mean_estimation(sample = sampleNP, weights = wi,
                  estimated_vars = "vote_pir")
#vote_pir
#0.4006072
#Estimation of the 95% confidence interval
estim <- mean_estimation(sample = sampleNP, weights = wi,
                           estimated_vars = "vote_pir")
std_dev <- fast_jackknife_variance(sample = sampleNP, weights = wi,
                                     estimated_vars = "vote_pir", N = 50000)
confidence_interval(estimation = estim, std_dev = std_dev, confidence = 0.95)
#lower.vote_pir upper.vote_pir
#0.4001341      0.4010803

wi <- sc_weights(propensities = pi$convenience)
summary(wi)
#Min.   1st Qu.    Median      Mean   3rd Qu.      Max.
#0.0004998 0.3185741 0.4549419 0.5044062 0.6003197 2.2479720

#### Code for examples in InfoUP section ####
covariates <- c("education_primaria", "education_secundaria",
                "education_terciaria", "age", "sex", "language")
model_based(sampleNP, population, covariates, "vote_pens",
            algorithm = "ridge", proc = c("center", "scale"))
#[1] 18642.85

model_based(sampleNP, population, covariates, "vote_pens",
              algorithm = "ridge", proc = c("center", "scale"), estimate_mean = TRUE)
#[1] 0.3731423

model_calibrated(sample_data = sampleNP, weights = 1, full_data = population,
                                     covariates = covariates, estimated_var = "vote_pens",
                                     algorithm = "ridge", proc = c("center","scale"),
                                     estimate_mean = TRUE)
#[1] 0.3431155

