library (timeSeries) # to extract time series
library (NlinTS)

data = LPP2005REC
##############
print ("The G-causality test")
model = causality.test (data[,1], data[,2], 2, FALSE)

model$summary ()

print ("Returned values")
print ("  Causality index: "); model$gci
print ("  Ftest statistic: "); model$Ftest
print ("  P-value: "); model$pvalue

############
print ("The non linear causality test")
model = nlin_causality.test (data[,1], data[,2], 2, c(2), c(4), 100)
model$summary ()

print ("Returned values")
print ("  Causality index: "); model$gci
print ("  Ftest statistic: "); model$Ftest
print ("  P-value: "); model$pvalue


##########
print ("---------------------------")
print ("The VAR MODEL")
print ("---------------------------")

#load data
data = LPP2005REC

# The lag parameter
lag = 1

# Prepare training data
train_data = data[1:(nrow (data) - 1), ]

# Build and train the model
model = varmlp (train_data, lag, c(10,5), 100)

# Predict the last row of the data
predictions = model$forecast (train_data)

# Show the predictions
print (predictions[nrow (predictions),])

# Update the model
model$train (data[nrow (data) - lag: nrow (data),])
##############


print ("---------------------------")
print ("The discrete  MI")
print ("---------------------------")
# Construct an integer dataframe with 2 columns
df = data.frame (c(3,2,4,4,3), c(1,4,4,3,3))
# The mutual information between columns of df
mi = mi_disc (df)
print (mi)

print ("---------------------------")
print ("The continuous MI")
print ("---------------------------")

# The mutual information between of the two first columns of the data with k = 3
print (mi_cont (data[,1], data[,2], 3))

print ("The discrete TE")
te = te_disc (c(3,2,1,4,3, 1,1,2,1), c(1,4,4,3,3, 2,1,2,3), 1, 1, normalize = FALSE)
print (te)

print ("---------------------------")
print ("The continuous  TE")
print ("---------------------------")
te = te_cont (data[,1], data[,2], 1, 1, 3, normalize = TRUE)
print (te)
