# TESTING SCRIPT FOR SURVBOOST PACKAGE
library(SurvBoost)

# Simulate stratified data, size is approximately 500 observations
TrueBeta <- c(0.5, 0.5, 0.0, 0.0, 0.0, -0.5, 0.5, 0.5, 0.0, 0.0)
set.seed(123)
data_small <- simulate_survival_cox(true_beta=TrueBeta, # provide true beta values
                                    base_hazard="auto", # use exponential distribution for baseline hazard
                                    num_strata=5, # generate 5 strata
                                    input_strata_size=100, # each stratum has about 100 observations
                                    cov_structure="ar", # correlation structure is AR1
                                    block_size=5, rho=0.6, # block size is 5 and correlation coefficient is 0.6
                                    censor_dist="unif", # censoring distribution is uniform
                                    censor_const=2, tau=Inf, normalized=F)

round(sapply(1:5,function(i) mean(data_small$time[data_small$strata_idx==i])), digits=2 ) # CHECK TIME
round(sapply(1:5,function(i) mean(data_small$delta[data_small$strata_idx==i])), digits=2) # CHECK CENSORING

# Extract variables needed to create formula
time <- data_small$time
delta <- data_small$delta
Z <- as.matrix(data_small[,-c(1,2,3)])
strata=data_small$strata_idx

# Generate formula
covariates <- paste("strata(strata_idx) +",paste(colnames(Z), collapse = " + "))
formula <- as.formula(paste("Surv(time,delta) ~ ", covariates))

# Check if strata is appropriate for stratification
strata.boosting(data_small$strata_idx, data_small$time)

# Example 1: boosting with a fixed number of iterations
test1 <- boosting_core(formula, data=data_small, rate=0.1, num_iter=75)

# Example 2: boosting algorithm iterates until 5 variables are selected
test2 <- boosting_core(formula, data=data_small, rate=0.1,
                       control_method="num_selected", control_parameter=list(num_select=5))

# Example 3: boosting method stops based on minimized BIC value
test3 <- boosting_core(formula, data=data_small, rate=0.1,
                       control_method="BIC", control_parameter=.5)

# Example 4: boosting method stops based on minimized AIC value
test4 <- boosting_core(formula, data=data_small, rate=0.1,
                       control_method="AIC")

# Example 5: boosting method stops when the change in likelihood is less than 0.001
test5 <- boosting_core(formula, data=data_small, rate=0.1,
                       control_method="likelihood")

# Example 6: boosting method stops based on cross validated mstop
test6 <- boosting_core(formula, data=data_small, rate=0.1,
                       control_method="cv", control_parameter = 5)

# Compare beta's generated by the six examples
rbind(TrueBeta, test1$beta, test2$beta, test3$beta, test4$beta, test5$beta, test6$beta)

summary.boosting(test1)
modelfit.boosting(test1)
plot.boosting(test1) # plots proportion of variables selected by iteration
plot.boosting(test1, type="coefficients") # plots coefficient paths by iteration
predict.boosting(test1)[1:6]
summary.test1 <- summary.boosting(test1)
fmla.test <- summary.test1$Formula
post.selection.fitting.boosting(fmla.test) # inference generated by refitting coxph() model after doing model selection with boosting

