# install packages
######################################################################
# Please note that version 1.5.2.2 of PerformanceAnalytics from github
# is needed for chart.QQPlot to function properly, you can check the
# commit history of "braverock/PerformanceAnalytics" for more details.
######################################################################
cran = c("sn", "kableExtra")
github = c("chindhanai/skewtInfo", "braverock/PerformanceAnalytics")
newCran <- cran[!(cran %in% installed.packages()[,"Package"])]
if(length(newCran)) {
  install.packages(newCran)
}
devtools::install_github(github)

# load packages
library(sn)
library(kableExtra)
library(PerformanceAnalytics)
library(skewtInfo)

# Figure 1
tsDRet = ts(Dreturns, start = c(1991, 12), frequency = 12)
plot(tsDRet*100, main = "", col = 4, ylab = "RETURNS(%)")
abline(h = 0, lty = 3)

# Table 1
# Define returns in each time period
returns1 <- Dreturns[1:61]
returns2 <- Dreturns[62:217]
returns3 <- Dreturns[218:289]

# Symmetric-t fit
tFitD1 <- st.mple(y = returns1, symmetr = TRUE)$dp
tFitD2 <- st.mple(y = returns2, symmetr = TRUE)$dp
tFitD3 <- st.mple(y = returns3, symmetr = TRUE)$dp
tFit <- rbind(tFitD1, tFitD2, tFitD3)

# Skew-t fit
stFitD1 <- st.mple(y = returns1, penalty = "Qpenalty")$dp
stFitD2 <- st.mple(y = returns2, penalty = "Qpenalty")$dp
stFitD3 <- st.mple(y = returns3, penalty = "Qpenalty")$dp
stFit <- rbind(stFitD1, stFitD2, stFitD3)

dt <- data.frame(tFit, stFit)
row.names(dt) <- c("D1 returns", "D2 returns", "D3 returns")
colnames(dt) <- c("location", "scale", "dof", "location", "scale", "slant", "dof")
############################################################################
# NOTE: The t-dist. dof estimate is not only large, but also highly unstable
############################################################################

kable(dt, format = "latex", booktabs = T, digits = 3) %>%
  kable_styling() %>%
  add_header_above(c(" " = 1, "Symmetric-t" = 3, "Skew-t" = 4))

# infoMat in 'Usage example in 'numerical evaluation of the skew - t inforamtion matrix'
expInfo_D2 <- stInfoMat(dp = stFitD2, type = "expected")$stInfoMat  # stFitD2 computed earlier
kable(expInfo_D2, align = 'c', format = "latex", digits = 3, booktabs = T) %>%
  kable_styling(position = "center")

# Table 2
set.seed(0)
###########################################################################
# n <- 1e5  This value was used for paper
n = 200  #This value is just for a quick computation
# The following computation can take several minutes, and you might want to
# use a smaller n just to see that the code works
###########################################################################
rand_asymp <- rst(n = n, dp = stFitD2)
obsInfo <- stInfoMat(y = rand_asymp, dp = stFitD2, type = "observed")
expInfo <- stInfoMat(dp = stFitD2, type = "expected")
obsInfoMat <- obsInfo$stInfoMat
expInfoMat <- expInfo$stInfoMat
AD <- obsInfoMat - expInfoMat
RD <- (obsInfoMat - expInfoMat)/expInfoMat
SE <- obsInfo$SEMat / sqrt(n)
ratio <- AD/SE
diagonal_elt <- data.frame("Diagonal" = c("I_11", "I_22", "I_33", "I_44"),
                           "Expected" = diag(expInfoMat), "Observed" = diag(obsInfoMat),
                           "AD"=diag(AD), "RD"= diag(RD), "SE"=diag(SE), "tstat.AD" = diag(ratio))

# Table 2
kable(diagonal_elt, format = "latex", digits = 3, align = 'c', booktabs = T) %>%
  kable_styling(position = "center")

offDiag_elt <- data.frame("Off-diagonal" = c("I_12", "I_13", "I_14", "I_23", "I_24", "I_34"),
                          "Expected" = expInfoMat[upper.tri(expInfoMat)],
                          "Observed" = obsInfoMat[upper.tri(obsInfoMat)],
                          "AD" = AD[upper.tri(AD)], "RD" = RD[upper.tri(RD)],
                          "SE" = SE[upper.tri(SE)], "tstat.AD" = ratio[upper.tri(ratio)])

kable(offDiag_elt, format = "latex", digits = 3, align = 'c', booktabs = T) %>%
  kable_styling(position = "center")

# Table 3
expInfo_D1 <- stInfoMat(dp = stFitD1, type = "expected")$stInfoMat
expInfo_D2 <- stInfoMat(dp = stFitD2, type = "expected")$stInfoMat # WAS MISSING
expInfo_D3 <- stInfoMat(dp = stFitD3, type = "expected")$stInfoMat
ev1 <- eigen(expInfo_D1)$values
ev2 <- eigen(expInfo_D2)$values
ev3 <- eigen(expInfo_D3)$values
ev <- rbind(ev1, ev2, ev3)
cd <- c(max(ev1)/min(ev1), max(ev2)/min(ev2), max(ev3)/min(ev3))
dt <- data.frame(ev, cd)
row.names(dt) <- c("D1 returns", "D2 returns", "D3 returns")
colnames(dt) <- c("lambda1", "lambda2", "lambda3", "lambda4", "condition numbers")

kable(dt, align = 'c', format = "latex", digits = 4, booktabs = T) %>%
  kable_styling(position = "center")

# Compute and display asymptotic correlation matrices
# in 'Asymptotic Correlations of the Four parameter MPLEs'
kable(cov2cor(solve(expInfo_D1)), align = 'c', format = "latex", digits = 3, booktabs = T) %>%
  kable_styling(position = "center")
kable(cov2cor(solve(expInfo_D2)), align = 'c', format = "latex", digits = 3, booktabs = T) %>%
  kable_styling(position = "center")
kable(cov2cor(solve(expInfo_D3)), align = 'c', format = "latex", digits = 3, booktabs = T) %>%
  kable_styling(position = "center")

# Example of Monte Carlo Studies and Huge Dof detection
# in 'A Monte Carlo Skew-t Fitting Difficulty and a Solution'
set.seed(123)
#####################################################################
# Skew-t parameters corresponding to the second period of the returns
# The code below takes about a minute
dp <- stFitD2
# M <- 1000 # This is the value used for the paper
M <- 100  # This value is used for seeing how the code works
#####################################################################
n <- 50
retReps <- matrix(NA, ncol = 50, nrow = M)
dim(retReps)
skewtFits <- matrix(NA, ncol = 4, nrow = M)
for (m in 1:M) {
  retReps[m, ] <- rst(n = n, dp = dp)
}
for (m in 1:M) {
  skewtFits[m, ] <- st.mple(y = retReps[m, ], penalty = "Qpenalty")$dp
}
skewtFitsHugeDof <- skewtFits[(skewtFits[, 4] > 1000),]
nrow(skewtFitsHugeDof)
skewtFitsHugeDof[1, ]

####################################################################################
# Results presented in Tables 4, 5, 6, 7, and Figure 2 (which is a visualization
# of Table 7 data) are obtained via Monte Carlo in which we first generate a large
# number of skew-t parameter vectors from skew-t random variable replicates.  If you
# wish to replicate the Monte Carlo results in those Tables and Figure 2, you should
# go to https://github.com/chindhanai/skewtInfo/tree/master/paper , and download the
# folder "Data" and the script mux.reproducibleMC.R, and run the latter.  A careful
# look at the details of that script, as well as the contents of the folder "Data",
# and its sub-folder "5000", will make it clear how we do the Monte Carlo.  We used
# this setup to avoid having to re-generate the skew-t MLE replicates.
####################################################################################
