### R code from vignette source 'article.Rnw'

###################################################
### code chunk number 1: preliminaries
###################################################
options(prompt = "R> ", continue = "+  ", width = 70, useFancyQuotes = FALSE)
library("tsmp")
library("magrittr")


###################################################
### code chunk number 2: motif
###################################################
data <- mp_fluss_data$walkjogrun$data
motifs <- tsmp(data, window_size = 80, exclusion_zone = 1/2) %>%
  find_motif(n_motifs = 3, radius = 10, exclusion_zone = 20) %T>% plot()


###################################################
### code chunk number 3: summary
###################################################
motifs


###################################################
### code chunk number 4: plot_motifs
###################################################
plot(motifs, type = "matrix")


###################################################
### code chunk number 5: segments
###################################################
segments <- motifs %>% fluss(num_segments = 2)
segments


###################################################
### code chunk number 6: plot_segments
###################################################
plot(segments, type = "data")


###################################################
### code chunk number 7: chains
###################################################
chains <- mp_gait_data %>% tsmp(window_size = 50, exclusion_zone = 1/4,
  verbose = 0) %>% find_chains()
chains


###################################################
### code chunk number 8: plot_chains
###################################################
plot(chains, ylab = "")


###################################################
### code chunk number 9: seed
###################################################
set.seed(2018)
data <- cumsum(sample(c(-1, 1), 40000, TRUE))


