install.packages("CoxPhLb")
library(CoxPhLb)
data("ExampleData1", package = "CoxPhLb")
dat1 <- ExampleData1

station.test.plot(a = dat1$a, v = dat1$y - dat1$a, delta = dat1$delta)
station.test(a = dat1$a, v = dat1$y - dat1$a, delta = dat1$delta)

fit.ee1 <- coxphlb(Surv(a, y, delta) ~ x1 + x2, data = dat1, method = "EE")
coxphlb(Surv(a, y, delta) ~ x1 + x2, data = dat1, method = "Bootstrap", seed.n = 1234)

ftest1 <- coxphlb.ftest(fit = fit.ee1, data = dat1, spec.p = 2, seed.n = 1234)
coxphlb.ftest.plot(ftest1, n.plot = 50, seed.n = 1234)

phtest11 <- coxphlb.phtest(fit = fit.ee1, data = dat1, spec.p = 1, seed.n = 1234)
phtest12 <- coxphlb.phtest(fit = fit.ee1, data = dat1, spec.p = 2, seed.n = 1234)
coxphlb.phtest.plot(phtest11, n.plot = 50, seed.n = 1234)
coxphlb.phtest.plot(phtest12, n.plot = 50, seed.n = 1234)

coxphlb.phtest(fit = fit.ee1, data = dat1, spec.p = NULL, seed.n = 1234)


install.packages("KMsurv")
data("channing", package = "KMsurv")
dat2 <- as.data.frame(cbind(ageentry = channing$ageentry/12, age = channing$age/12,
                      death = channing$death, gender = channing$gender))
dat2 <- dat2[dat2$ageentry >= 65, ]

station.test.plot(a = (dat2$ageentry - 65), v = (dat2$age - dat2$ageentry),
                  delta = dat2$death)

station.test(a = (dat2$ageentry - 65), v = (dat2$age - dat2$ageentry),
             delta = dat2$death)

fit.ee2 <- coxphlb(Surv((ageentry - 65), (age - 65), death) ~ gender, data = dat2,
                   method = "EE")

coxphlb(Surv((ageentry - 65), (age - 65), death) ~ gender, data = dat2,
        method = "Bootstrap", seed.n = 1234)

phtest2 <- coxphlb.phtest(fit = fit.ee2, data = dat2, spec.p = 1, seed.n = 1234)
coxphlb.phtest.plot(phtest2, seed.n = 1234)
