######################################################################
###   Codes for CopulaCenR package manuscript 4.1, 4.2, 4.3 ###
###   The results are obtained using:
###    R 3.5.2 and CopulaCenR 1.1.2,
###
###   with other packages:
###   caret 6.0-81, copula 0.999-19, corpcor 1.6.9,
###   flexsurv 1.1, icenReg 2.0.9, magrittr 1.5, plotly 4.8.0,
###   pracma 2.2.2, and survival 2.43-3
######################################################################



######  Bivariate event time generation ######
library(CopulaCenR)
set.seed(1)
dat <- data_sim_copula(n = 500, copula = "Clayton", eta = 3, dist = "Weibull",
                       baseline = c(0.1,2), var_list = c("var1", "var2"),
                       COV_beta = c(0.1, 0.1),
                       x1 = cbind(rnorm(500, 6, 2), rbinom(500, 1, 0.5)),
                       x2 =  cbind(rnorm(500, 6, 2), rbinom(500, 1, 0.5)))
head(dat)
plot(x = dat$time[dat$ind == 1], y = dat$time[dat$ind == 2],
     xlab = expression(t[1]), ylab = expression(t[2]),
     cex.axis = 1, cex.lab = 1.3)





###### Fitting copula models for bivariate right-censored data ######
data("DRS", package = "CopulaCenR")
head(DRS)

library(CopulaCenR)
clayton_wb <- rc_par_copula(data = DRS, var_list = "treat",
              copula = "Clayton", m.dist = "Weibull",
              method = "BFGS")
summary(clayton_wb)

# AIC and BIC
AIC(clayton_wb)
BIC(clayton_wb)

# calculate Kendall's tau
tau_copula(eta = as.numeric(coef(clayton_wb)["eta"]), copula = "Clayton")

# extract fitted values
# "lp" for linear predictors and "survival" for survival probabilities
fit1 <- fitted(clayton_wb, type = "lp")
fit1[1:3, ]

fit2 <- fitted(clayton_wb, type = "survival")
fit2[1:3, ]

# predict for new observations
# "lp" for linear predictors and "survival" for survival probabilities
newdata1 = data.frame(id = rep(1:2, each=2), ind = rep(c(1,2),2),
                      time = rep(40,4),
                      treat = factor(c(0,1,0,2)))
newdata1
predict(object = clayton_wb, newdata = newdata1, type = "lp")
predict(object = clayton_wb, newdata = newdata1, type = "survival")






###### Fitting copula models for bivariate interval-censored data ######
data("AREDS", package = "CopulaCenR")
head(AREDS)

library(CopulaCenR)
copula2_sp <- ic_spTran_copula(data = AREDS, copula = "Copula2",
              var_list = c("ENROLLAGE","rs2284665","SevScaleBL"),
              l = 0, u = 15, m = 3, r = 3)
summary(copula2_sp)

# AIC and BIC
AIC(copula2_sp)
BIC(copula2_sp)

# calculate Kendall's tau
tau_copula(eta = as.numeric(coef(copula2_sp)[c("alpha","kappa")]), copula = "Copula2")

# fit a null model without rs2284665 and perform the score test for rs2284665
copula2_sp_null <- ic_spTran_copula(data = AREDS, copula = "Copula2",
                                var_list = c("ENROLLAGE","SevScaleBL"),
                                l = 0, u = 15, m = 3, r = 3)
score_copula(object = copula2_sp_null, var_score = "rs2284665")

# perform LRT for rs2284665
lrt_copula(model1 = copula2_sp, model2 = copula2_sp_null)

# plot survival probabilities for new observations
# class = "joint", "conditional" or "marginal" for three types of curves
newdata2 <- data.frame(id = rep(1:3, each=2), ind = rep(c(1,2),3),
                       SevScaleBL = rep(3,6),
                       ENROLLAGE = rep(60,6),
                       rs2284665 = c(0,0,1,1,2,2))
newdata2
plot(x = copula2_sp, class = "joint", newdata = newdata2)
plot(x = copula2_sp, class = "conditional", newdata = newdata2,
     cond_margin = 2, cond_time = 5, ylim = c(0.25,1),
     ylab = "Conditional Survival Probability")
plot(x = copula2_sp, class = "marginal", newdata = newdata2,
     plot_margin = 1, ylim = c(0.6,1),
     ylab = "Marginal Survival Probability")


